# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from openobd_protocol.Messages import Empty_pb2 as openobd__protocol_dot_Messages_dot_Empty__pb2
from openobd_protocol.SessionController.Messages import SessionController_pb2 as openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2


class sessionControllerStub(object):
    """
    The sessionController can be used to start an openOBD session.
    ``` mermaid
    sequenceDiagram
    Client->>Server: getSessionControllerToken
    Server->>Client: SessionControllerToken
    Client->>Server: startSessionOnTicket
    Server->>Client: SessionInfo
    Note over Client,Server: openOBD session<br/>
    ```
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.getSessionControllerToken = channel.unary_unary(
                '/openOBD.v1.sessionController/getSessionControllerToken',
                request_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.Authenticate.SerializeToString,
                response_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionControllerToken.FromString,
                )
        self.startSessionOnTicket = channel.unary_unary(
                '/openOBD.v1.sessionController/startSessionOnTicket',
                request_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.TicketId.SerializeToString,
                response_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
                )
        self.startSessionOnConnector = channel.unary_unary(
                '/openOBD.v1.sessionController/startSessionOnConnector',
                request_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.ConnectorId.SerializeToString,
                response_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
                )
        self.getSession = channel.unary_unary(
                '/openOBD.v1.sessionController/getSession',
                request_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionId.SerializeToString,
                response_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
                )
        self.interruptSession = channel.unary_unary(
                '/openOBD.v1.sessionController/interruptSession',
                request_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionId.SerializeToString,
                response_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
                )
        self.getSessionList = channel.unary_unary(
                '/openOBD.v1.sessionController/getSessionList',
                request_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
                response_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfoList.FromString,
                )


class sessionControllerServicer(object):
    """
    The sessionController can be used to start an openOBD session.
    ``` mermaid
    sequenceDiagram
    Client->>Server: getSessionControllerToken
    Server->>Client: SessionControllerToken
    Client->>Server: startSessionOnTicket
    Server->>Client: SessionInfo
    Note over Client,Server: openOBD session<br/>
    ```
    """

    def getSessionControllerToken(self, request, context):
        """
        This service is used to authenticate with the SessionController service as the client.
        This is to ensure that the person using openOBD has the required credentials. The credentials that are required to
        sent can be seen in Authenticate. It returns a SessionControllerToken to be received by the client.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def startSessionOnTicket(self, request, context):
        """
        This service is used to start an openOBD session on a ticket. This is the primary method of starting a session. The
        information required to start a session using this method is the ticket number found on the Jifeline Partner Dashboard
        as TicketId. For a successful call a new session is created and SessionInfo message containing all relevant
        information is returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def startSessionOnConnector(self, request, context):
        """
        This service is used to start an openOBD session on a connector (J-ReX). This method to start a
        session is used for developmental purposes only. The ConnectorId is required to start a successful session.
        The SessionInfo message is returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getSession(self, request, context):
        """
        This service is used to retrieve a single openOBD session. The session is retrieved using the SessionId and
        irrespective of the session state. It returns the SessionInfo message.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def interruptSession(self, request, context):
        """
        This service to used to stop/interrupt an `active` or `available` openOBD session. It returns the interrupted
        session as a SessionInfo message.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getSessionList(self, request, context):
        """
        This service is used to retrieve a list all openOBD sessions started by the client irrespective of their state.
        It returns a list of SessionInfo messages as a SessionInfoList message.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_sessionControllerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'getSessionControllerToken': grpc.unary_unary_rpc_method_handler(
                    servicer.getSessionControllerToken,
                    request_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.Authenticate.FromString,
                    response_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionControllerToken.SerializeToString,
            ),
            'startSessionOnTicket': grpc.unary_unary_rpc_method_handler(
                    servicer.startSessionOnTicket,
                    request_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.TicketId.FromString,
                    response_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.SerializeToString,
            ),
            'startSessionOnConnector': grpc.unary_unary_rpc_method_handler(
                    servicer.startSessionOnConnector,
                    request_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.ConnectorId.FromString,
                    response_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.SerializeToString,
            ),
            'getSession': grpc.unary_unary_rpc_method_handler(
                    servicer.getSession,
                    request_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionId.FromString,
                    response_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.SerializeToString,
            ),
            'interruptSession': grpc.unary_unary_rpc_method_handler(
                    servicer.interruptSession,
                    request_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionId.FromString,
                    response_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.SerializeToString,
            ),
            'getSessionList': grpc.unary_unary_rpc_method_handler(
                    servicer.getSessionList,
                    request_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                    response_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfoList.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'openOBD.v1.sessionController', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class sessionController(object):
    """
    The sessionController can be used to start an openOBD session.
    ``` mermaid
    sequenceDiagram
    Client->>Server: getSessionControllerToken
    Server->>Client: SessionControllerToken
    Client->>Server: startSessionOnTicket
    Server->>Client: SessionInfo
    Note over Client,Server: openOBD session<br/>
    ```
    """

    @staticmethod
    def getSessionControllerToken(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.sessionController/getSessionControllerToken',
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.Authenticate.SerializeToString,
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionControllerToken.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def startSessionOnTicket(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.sessionController/startSessionOnTicket',
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.TicketId.SerializeToString,
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def startSessionOnConnector(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.sessionController/startSessionOnConnector',
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.ConnectorId.SerializeToString,
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getSession(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.sessionController/getSession',
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionId.SerializeToString,
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def interruptSession(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.sessionController/interruptSession',
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionId.SerializeToString,
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfo.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getSessionList(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.sessionController/getSessionList',
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.SessionInfoList.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
