# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from openobd_protocol.Messages import Empty_pb2 as openobd__protocol_dot_Messages_dot_Empty__pb2
from openobd_protocol.Session.Messages import ServiceResult_pb2 as openobd__protocol_dot_Session_dot_Messages_dot_ServiceResult__pb2
from openobd_protocol.Session.Messages import Session_pb2 as openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2


class sessionStub(object):
    """
    Calls to the session services require either an initial authentication token or a session token. This token needs to be send as bearer token
    in the header of the gRPC request.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.authenticate = channel.unary_unary(
                '/openOBD.v1.session/authenticate',
                request_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
                response_deserializer=openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2.SessionToken.FromString,
                )
        self.assertAuthenticationPossible = channel.unary_unary(
                '/openOBD.v1.session/assertAuthenticationPossible',
                request_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
                response_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                )
        self.openSessionTokenStream = channel.unary_stream(
                '/openOBD.v1.session/openSessionTokenStream',
                request_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
                response_deserializer=openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2.SessionToken.FromString,
                )
        self.finish = channel.unary_unary(
                '/openOBD.v1.session/finish',
                request_serializer=openobd__protocol_dot_Session_dot_Messages_dot_ServiceResult__pb2.ServiceResult.SerializeToString,
                response_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                )


class sessionServicer(object):
    """
    Calls to the session services require either an initial authentication token or a session token. This token needs to be send as bearer token
    in the header of the gRPC request.
    """

    def authenticate(self, request, context):
        """
        When an openOBD session is created and attached to a running connection on the Jifeline network it is in an 'available' state.
        The `authenticate()` rpc call is used to "claim" an openOBD session.  The `authenticate()` call will transition the openOBD
        session into the 'active' state. An authentication token is required. This token can be obtained from the `SessionInfo` message or from the `FunctionContext` message (in case a new function context has been created).
        <br/>
        Once this call has been made, any subsequent calls need to be made using a new bearer token that is contained in the `SessionToken` response.
        It is advised that the next step in your process is to set up a SessionToken stream using the `openSessionTokenStream()` rpc call.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def assertAuthenticationPossible(self, request, context):
        """
        The `assertAuthenticationPossible()` method can be called just like the `authenticate()` method. It does not authenticate and therefore can be used to check whether the
        session is still in the 'available' state. If it is not, this call will result in an exception. An authentication token is required for this call.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def openSessionTokenStream(self, request, context):
        """
        The `openSessionTokenStream()` rpc call is used to open a continuous stream of `SessionToken` messages. When a new `SessionToken` is received on this stream
        the subsequent calls that are being made on an openOBD session need to incorporate the freshly received token as their bearer token in the header of their gRPC calls.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def finish(self, request, context):
        """
        The `finish(ServiceResult)` rpc call is used to gracefully finish a function context or (when nog contexts where created) the openOBD session. The `ServiceResult` argument message indicates whether the service was executed successfully.
        A new `authenticate()` rpc call can be made on the session when a function context was finished. The openOBD session terminates when the last function context has been finished.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_sessionServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'authenticate': grpc.unary_unary_rpc_method_handler(
                    servicer.authenticate,
                    request_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                    response_serializer=openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2.SessionToken.SerializeToString,
            ),
            'assertAuthenticationPossible': grpc.unary_unary_rpc_method_handler(
                    servicer.assertAuthenticationPossible,
                    request_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                    response_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            ),
            'openSessionTokenStream': grpc.unary_stream_rpc_method_handler(
                    servicer.openSessionTokenStream,
                    request_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                    response_serializer=openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2.SessionToken.SerializeToString,
            ),
            'finish': grpc.unary_unary_rpc_method_handler(
                    servicer.finish,
                    request_deserializer=openobd__protocol_dot_Session_dot_Messages_dot_ServiceResult__pb2.ServiceResult.FromString,
                    response_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'openOBD.v1.session', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class session(object):
    """
    Calls to the session services require either an initial authentication token or a session token. This token needs to be send as bearer token
    in the header of the gRPC request.
    """

    @staticmethod
    def authenticate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.session/authenticate',
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2.SessionToken.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def assertAuthenticationPossible(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.session/assertAuthenticationPossible',
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def openSessionTokenStream(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/openOBD.v1.session/openSessionTokenStream',
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            openobd__protocol_dot_Session_dot_Messages_dot_Session__pb2.SessionToken.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def finish(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.session/finish',
            openobd__protocol_dot_Session_dot_Messages_dot_ServiceResult__pb2.ServiceResult.SerializeToString,
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
