# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from openobd_protocol.Function.Messages import Function_pb2 as openobd__protocol_dot_Function_dot_Messages_dot_Function__pb2
from openobd_protocol.FunctionBroker.Messages import FunctionBroker_pb2 as openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2
from openobd_protocol.Messages import Empty_pb2 as openobd__protocol_dot_Messages_dot_Empty__pb2
from openobd_protocol.SessionController.Messages import SessionController_pb2 as openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2


class functionBrokerStub(object):
    """
    The function broker is an intermediary between function hosting and function launchers. Dashboard integration of your openOBD functions is enabled by the function broker.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.getFunctionBrokerToken = channel.unary_unary(
                '/openOBD.v1.functionBroker/getFunctionBrokerToken',
                request_serializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.Authenticate.SerializeToString,
                response_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionBrokerToken.FromString,
                )
        self.openFunctionStream = channel.stream_stream(
                '/openOBD.v1.functionBroker/openFunctionStream',
                request_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.SerializeToString,
                response_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.FromString,
                )
        self.runFunction = channel.unary_unary(
                '/openOBD.v1.functionBroker/runFunction',
                request_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionCall.SerializeToString,
                response_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.FromString,
                )
        self.getFunctionRegistration = channel.unary_unary(
                '/openOBD.v1.functionBroker/getFunctionRegistration',
                request_serializer=openobd__protocol_dot_Function_dot_Messages_dot_Function__pb2.FunctionId.SerializeToString,
                response_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionRegistration.FromString,
                )
        self.generateFunctionSignature = channel.unary_unary(
                '/openOBD.v1.functionBroker/generateFunctionSignature',
                request_serializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
                response_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionSignature.FromString,
                )


class functionBrokerServicer(object):
    """
    The function broker is an intermediary between function hosting and function launchers. Dashboard integration of your openOBD functions is enabled by the function broker.
    """

    def getFunctionBrokerToken(self, request, context):
        """
        This service is used to authenticate with the FunctionBroker service as a client.
        The credentials that are required need to be contained in the Authenticate message. It returns a FunctionBrokerToken.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def openFunctionStream(self, request_iterator, context):
        """
        The `openFunctionStream()` call opens a bi-directional stream.
        The outgoing stream is used by a function launcher to register its functions to the broker. One function launcher may
        send multiple function definitions over the same stream and register that they are on-line and ready to be called by another party.
        <br/>
        The incoming stream is use used by the function broker to forward function calls from a function caller to a function launcher.
        Only when all function registrations are registered as off-line, the bi-directional stream will be closed.
        <br/>
        The function broker regularly sends FunctionUpdate "ping" messages, that are meant to keep the stream open (and check if the function launcher is still there).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def runFunction(self, request, context):
        """
        The `runFunction()` call is used by function callers to execute a function, offered by a function launcher, on their openOBD session.
        The openOBD function that is being called should be registered as 'on-line' through the `openFunctionCallStream()` call.
        <br/>
        When the function is known by the function broker and registered as 'on-line', the function broker will check some preconditions:

        - Is the caller allowed to make this function call
        - Is the right function information registered through `registerFunctionDetails()`. If it is not done yet, the function broker will register the details.
        - Is the openOBD session in the 'available' state (i.e. is it possible for an eventual launcher to `authenticate()` with the supplied information.

        When all preconditions described above are met, the function broker will forward the FunctionCall to the specific function launcher that is hosting the function.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getFunctionRegistration(self, request, context):
        """
        The `getFunctionRegistration()` may be used to function callers to check te availability and some more information of a certain function without executing it.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def generateFunctionSignature(self, request, context):
        """
        The `generateFunctionSignature()` call can be used to generate a new function id and signature.
        This signature ensures that the retrieved id can only be used by the provider that made the registration. This makes is impossible for other parties to forge a function id once it is assigned to a specific provider.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_functionBrokerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'getFunctionBrokerToken': grpc.unary_unary_rpc_method_handler(
                    servicer.getFunctionBrokerToken,
                    request_deserializer=openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.Authenticate.FromString,
                    response_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionBrokerToken.SerializeToString,
            ),
            'openFunctionStream': grpc.stream_stream_rpc_method_handler(
                    servicer.openFunctionStream,
                    request_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.FromString,
                    response_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.SerializeToString,
            ),
            'runFunction': grpc.unary_unary_rpc_method_handler(
                    servicer.runFunction,
                    request_deserializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionCall.FromString,
                    response_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.SerializeToString,
            ),
            'getFunctionRegistration': grpc.unary_unary_rpc_method_handler(
                    servicer.getFunctionRegistration,
                    request_deserializer=openobd__protocol_dot_Function_dot_Messages_dot_Function__pb2.FunctionId.FromString,
                    response_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionRegistration.SerializeToString,
            ),
            'generateFunctionSignature': grpc.unary_unary_rpc_method_handler(
                    servicer.generateFunctionSignature,
                    request_deserializer=openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.FromString,
                    response_serializer=openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionSignature.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'openOBD.v1.functionBroker', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class functionBroker(object):
    """
    The function broker is an intermediary between function hosting and function launchers. Dashboard integration of your openOBD functions is enabled by the function broker.
    """

    @staticmethod
    def getFunctionBrokerToken(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.functionBroker/getFunctionBrokerToken',
            openobd__protocol_dot_SessionController_dot_Messages_dot_SessionController__pb2.Authenticate.SerializeToString,
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionBrokerToken.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def openFunctionStream(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(request_iterator, target, '/openOBD.v1.functionBroker/openFunctionStream',
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.SerializeToString,
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def runFunction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.functionBroker/runFunction',
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionCall.SerializeToString,
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionUpdate.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getFunctionRegistration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.functionBroker/getFunctionRegistration',
            openobd__protocol_dot_Function_dot_Messages_dot_Function__pb2.FunctionId.SerializeToString,
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionRegistration.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def generateFunctionSignature(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/openOBD.v1.functionBroker/generateFunctionSignature',
            openobd__protocol_dot_Messages_dot_Empty__pb2.EmptyMessage.SerializeToString,
            openobd__protocol_dot_FunctionBroker_dot_Messages_dot_FunctionBroker__pb2.FunctionSignature.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
