from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, ArrayType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Coverage_GroupingSchema:
    """
    Financial instrument which may be used to reimburse or pay for health care
    products and services.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Financial instrument which may be used to reimburse or pay for health care
        products and services.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        group: Identifies a style or collective of coverage issued by the underwriter, for
            example may be used to identify an employer group. May also be referred to as
            a Policy or Group ID.

        groupDisplay: A short description for the group.

        subGroup: Identifies a style or collective of coverage issued by the underwriter, for
            example may be used to identify a subset of an employer group.

        subGroupDisplay: A short description for the subgroup.

        plan: Identifies a style or collective of coverage issued by the underwriter, for
            example may be used to identify a collection of benefits provided to
            employees. May be referred to as a Section or Division ID.

        planDisplay: A short description for the plan.

        subPlan: Identifies a sub-style or sub-collective of coverage issued by the
            underwriter, for example may be used to identify a subset of a collection of
            benefits provided to employees.

        subPlanDisplay: A short description for the subplan.

        class: Identifies a style or collective of coverage issues by the underwriter, for
            example may be used to identify a class of coverage such as a level of
            deductables or co-payment.

        classDisplay: A short description for the class.

        subClass: Identifies a sub-style or sub-collective of coverage issues by the
            underwriter, for example may be used to identify a subclass of coverage such
            as a sub-level of deductables or co-payment.

        subClassDisplay: A short description for the subclass.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema

        if (
            max_recursion_limit
            and nesting_list.count("Coverage_Grouping") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Coverage_Grouping"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Identifies a style or collective of coverage issued by the underwriter, for
                # example may be used to identify an employer group. May also be referred to as
                # a Policy or Group ID.
                StructField("group", StringType(), True),
                # A short description for the group.
                StructField("groupDisplay", StringType(), True),
                # Identifies a style or collective of coverage issued by the underwriter, for
                # example may be used to identify a subset of an employer group.
                StructField("subGroup", StringType(), True),
                # A short description for the subgroup.
                StructField("subGroupDisplay", StringType(), True),
                # Identifies a style or collective of coverage issued by the underwriter, for
                # example may be used to identify a collection of benefits provided to
                # employees. May be referred to as a Section or Division ID.
                StructField("plan", StringType(), True),
                # A short description for the plan.
                StructField("planDisplay", StringType(), True),
                # Identifies a sub-style or sub-collective of coverage issued by the
                # underwriter, for example may be used to identify a subset of a collection of
                # benefits provided to employees.
                StructField("subPlan", StringType(), True),
                # A short description for the subplan.
                StructField("subPlanDisplay", StringType(), True),
                # Identifies a style or collective of coverage issues by the underwriter, for
                # example may be used to identify a class of coverage such as a level of
                # deductables or co-payment.
                StructField("class", StringType(), True),
                # A short description for the class.
                StructField("classDisplay", StringType(), True),
                # Identifies a sub-style or sub-collective of coverage issues by the
                # underwriter, for example may be used to identify a subclass of coverage such
                # as a sub-level of deductables or co-payment.
                StructField("subClass", StringType(), True),
                # A short description for the subclass.
                StructField("subClassDisplay", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
