# coding: utf-8
# -----------------------------------------------------------------------------------
# <copyright company="Aspose" file="list_insert.py">
#   Copyright (c) 2020 Aspose.Words for Cloud
# </copyright>
# <summary>
#   Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
# </summary>
# -----------------------------------------------------------------------------------
import pprint
import re  # noqa: F401

import six


class ListInsert(object):
    """Insert document to document list.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'template': 'str'
    }

    attribute_map = {
        'template': 'Template'
    }

    def __init__(self, template=None):  # noqa: E501
        """ListInsert - a model defined in Swagger"""  # noqa: E501

        self._template = None
        self.discriminator = None

        if template is not None:
            self.template = template

    @property
    def template(self):
        """Gets the template of this ListInsert.  # noqa: E501

        Gets or sets a value indicating whether specifies whether list should be restarted at each section. Default value is false.  # noqa: E501

        :return: The template of this ListInsert.  # noqa: E501
        :rtype: str
        """
        return self._template

    @template.setter
    def template(self, template):
        """Sets the template of this ListInsert.

        Gets or sets a value indicating whether specifies whether list should be restarted at each section. Default value is false.  # noqa: E501

        :param template: The template of this ListInsert.  # noqa: E501
        :type: str
        """
        allowed_values = ["BulletDefault", "BulletDisk", "BulletCircle", "BulletSquare", "BulletDiamonds", "BulletArrowHead", "BulletTick", "NumberDefault", "NumberArabicDot", "NumberArabicParenthesis", "NumberUppercaseRomanDot", "NumberUppercaseLetterDot", "NumberLowercaseLetterParenthesis", "NumberLowercaseLetterDot", "NumberLowercaseRomanDot", "OutlineNumbers", "OutlineLegal", "OutlineBullets", "OutlineHeadingsArticleSection", "OutlineHeadingsLegal", "OutlineHeadingsNumbers", "OutlineHeadingsChapter"]  # noqa: E501
        if not template.isdigit():
            if template not in allowed_values:
                raise ValueError(
                    "Invalid value for `template` ({0}), must be one of {1}"  # noqa: E501
                    .format(template, allowed_values))
            self._template = template
        else:
            self._template = allowed_values[int(template) if six.PY3 else long(template)]


    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListInsert):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other