# CellOracle
[![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/morris-lab/CellOracle/build_check.yml?branch=master)](https://github.com/morris-lab/CellOracle/actions/workflows/build_check.yml)
[![PyPI](https://img.shields.io/pypi/v/celloracle?color=blue)](https://pypi.org/project/celloracle/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/celloracle)](https://pypi.org/project/celloracle/)
[![PyPI - Wheel](https://img.shields.io/pypi/wheel/celloracle)](https://pypi.org/project/celloracle/)
[![Downloads](https://static.pepy.tech/personalized-badge/celloracle?period=total&units=international_system&left_color=grey&right_color=orange&left_text=Downloads)](https://pepy.tech/project/celloracle)
[![Docker Pulls](https://img.shields.io/docker/pulls/kenjikamimoto126/celloracle_ubuntu?color=red)](https://hub.docker.com/r/kenjikamimoto126/celloracle_ubuntu)

CellOracle is a python library for in silico gene perturbation analyses using single-cell omics data and Gene Regulatory Network models.

For more information, please read our paper: [Dissecting cell identity via network inference and in silico gene perturbation](https://www.nature.com/articles/s41586-022-05688-9).


### Documentation, Codes, and Tutorials
CellOracle documentation is available through the link below.

[Web documentation](https://morris-lab.github.io/CellOracle.documentation/)


### Questions and errors
If you have a question, error, bug, or problem, please use the [Github issue page](https://github.com/morris-lab/CellOracle/issues).

### Supported Species and reference genomes

- Human: ['hg38', 'hg19']
- Mouse: ['mm39', 'mm10', 'mm9']
- S.cerevisiae: ["sacCer2", "sacCer3"]
- Zebrafish: ["danRer7", "danRer10", "danRer11"]
- Xenopus tropicalis: ["xenTro2", "xenTro3"]
- Xenopus laevis: ["Xenopus_laevis_v10.1"]
- Rat: ["rn4", "rn5", "rn6"]
- Drosophila: ["dm3", "dm6"]
- C.elegans: ["ce6", "ce10"]
- Arabidopsis: ["TAIR10"]
- Chicken: ["galGal4", "galGal5", "galGal6"]
- Guinea Pig: ["Cavpor3.0"]
- Pig: ["Sscrofa11.1"]

### Changelog

Please go to [this page](https://morris-lab.github.io/CellOracle.documentation/changelog/index.html).
