import { Duration } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * A State Machine.
 *
 * @stability stable
 */
export interface IStateMachine {
    /**
     * The ARN of the state machine.
     *
     * @stability stable
     */
    readonly stateMachineArn: string;
}
/**
 * Properties for a StateMachineCustomResourceProvider.
 *
 * @stability stable
 */
export interface StateMachineCustomResourceProviderProps {
    /**
     * The state machine.
     *
     * @stability stable
     */
    readonly stateMachine: IStateMachine;
    /**
     * Timeout.
     *
     * @default Duration.minutes(30)
     * @stability stable
     */
    readonly timeout?: Duration;
}
/**
 * A state machine custom resource provider.
 *
 * @stability stable
 */
export declare class StateMachineCustomResourceProvider extends Construct {
    /**
     * The service token.
     *
     * @stability stable
     */
    readonly serviceToken: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: StateMachineCustomResourceProviderProps);
    private createCfnResponseFn;
}
