"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackTextract = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const slack_events_1 = require("../slack-events");
const detect_function_1 = require("./detect-function");
/**
 * Extract text from images posted to Slack using Amazon Textract.
 *
 * @stability stable
 */
class SlackTextract extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new detect_function_1.DetectFunction(this, 'handler', {
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            logRetention: logs.RetentionDays.ONE_MONTH,
            environment: {
                SLACK_TOKEN: props.botToken.toString(),
            },
        });
        handler.addToRolePolicy(new iam.PolicyStatement({
            actions: ['textract:DetectDocumentText'],
            resources: ['*'],
        }));
        new slack_events_1.SlackEvents(this, 'SlackEvents', {
            signingSecret: props.signingSecret,
        });
        const fileSharedRule = new events.Rule(this, 'SlackEventsRule', {
            eventPattern: {
                detail: {
                    event: {
                        type: ['file_shared'],
                    },
                },
                resources: [props.appId],
                source: ['slack'],
            },
        });
        fileSharedRule.addTarget(new targets.LambdaFunction(handler, {
            event: events.RuleTargetInput.fromEventPath('$.detail.event'),
        }));
    }
}
exports.SlackTextract = SlackTextract;
_a = JSII_RTTI_SYMBOL_1;
SlackTextract[_a] = { fqn: "cloudstructs.SlackTextract", version: "0.4.15" };
//# sourceMappingURL=data:application/json;base64,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