"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackAppManifest = exports.SlackAppManifestShortcutType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const nodeUrl = require("url");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Type of shortcuts.
 *
 * @see https://api.slack.com/interactivity/shortcuts
 * @stability stable
 */
var SlackAppManifestShortcutType;
(function (SlackAppManifestShortcutType) {
    SlackAppManifestShortcutType["MESSAGE"] = "message";
    SlackAppManifestShortcutType["GLOBAL"] = "global";
})(SlackAppManifestShortcutType = exports.SlackAppManifestShortcutType || (exports.SlackAppManifestShortcutType = {}));
;
/**
 * A Slack app manifest.
 *
 * @see https://api.slack.com/reference/manifests
 * @stability stable
 */
class SlackAppManifest {
    /**
     * @stability stable
     */
    constructor(props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        this.props = props;
        validateLength('app name', 35, props.name);
        validateLength('app description', 140, props.description);
        validateLength('app long description', 4000, props.longDescription);
        validateColor(props.backgroundColor);
        validateUrl((_b = props.eventSubscriptions) === null || _b === void 0 ? void 0 : _b.requestUrl);
        validateItems('bot events', 100, (_c = props.eventSubscriptions) === null || _c === void 0 ? void 0 : _c.botEvents);
        validateItems('users events', 100, (_d = props.eventSubscriptions) === null || _d === void 0 ? void 0 : _d.userEvents);
        validateUrl((_e = props.interactivity) === null || _e === void 0 ? void 0 : _e.requestUrl);
        validateUrl((_f = props.interactivity) === null || _f === void 0 ? void 0 : _f.messageMenuOptionsUrl);
        validateLength('bot display name', 80, (_g = props.botUser) === null || _g === void 0 ? void 0 : _g.displayName);
        validateItems('shortcuts', 5, props.shortcuts);
        (_h = props.shortcuts) === null || _h === void 0 ? void 0 : _h.forEach((shortcut) => {
            validateLength('shortcut callback ID', 255, shortcut.callbackId);
            validateLength('shortcut description', 150, shortcut.description);
        });
        validateItems('slash commands', 5, props.slashCommands);
        (_j = props.slashCommands) === null || _j === void 0 ? void 0 : _j.forEach((command) => {
            validateLength('slash command', 32, command.command);
            validateLength('slash command description', 2000, command.description),
                validateUrl(command.url);
            validateLength('slash command use hint', 1000, command.usageHint);
        });
        validateItems('workflow steps', 10, props.workflowSteps);
        (_k = props.workflowSteps) === null || _k === void 0 ? void 0 : _k.forEach((step) => {
            validateLength('workflow step name', 50, step.name);
            validateLength('workflow step callback ID', 50, step.callbackId);
        });
        validateItems('unfurls domains', 5, props.unfurlDomains);
        validateItems('OAuth redirect URLs', 1000, (_l = props.oauthConfig) === null || _l === void 0 ? void 0 : _l.redirectUrls);
        (_o = (_m = props.oauthConfig) === null || _m === void 0 ? void 0 : _m.redirectUrls) === null || _o === void 0 ? void 0 : _o.forEach((url) => {
            validateUrl(url, false);
        });
        validateItems('bot scopes', 255, (_p = props.oauthConfig) === null || _p === void 0 ? void 0 : _p.botScopes);
        validateItems('user scopes', 255, (_q = props.oauthConfig) === null || _q === void 0 ? void 0 : _q.userScopes);
    }
    /**
     * @stability stable
     */
    render(construct) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v;
        const schema = {
            _metadata: {
                major_version: this.props.majorVersion,
                minor_version: this.props.minorVersion,
            },
            display_information: {
                name: this.props.name,
                description: this.props.description,
                long_description: this.props.longDescription,
                background_color: (_b = prefixWith('#', this.props.backgroundColor)) === null || _b === void 0 ? void 0 : _b.toLowerCase(),
            },
            settings: {
                allowed_ip_address_ranges: this.props.allowedIpAddressRanges,
                event_subscriptions: {
                    request_url: (_c = this.props.eventSubscriptions) === null || _c === void 0 ? void 0 : _c.requestUrl,
                    bot_events: (_d = this.props.eventSubscriptions) === null || _d === void 0 ? void 0 : _d.botEvents,
                    user_events: (_e = this.props.eventSubscriptions) === null || _e === void 0 ? void 0 : _e.userEvents,
                },
                interactivity: this.props.interactivity
                    ? {
                        is_enabled: (_g = (_f = this.props.interactivity) === null || _f === void 0 ? void 0 : _f.enabled) !== null && _g !== void 0 ? _g : true,
                        request_url: (_h = this.props.interactivity) === null || _h === void 0 ? void 0 : _h.requestUrl,
                        message_menu_options_url: (_j = this.props.interactivity) === null || _j === void 0 ? void 0 : _j.messageMenuOptionsUrl,
                    }
                    : undefined,
                org_deploy_enabled: this.props.orgDeploy,
                socket_mode_enabled: this.props.socketMode,
            },
            features: {
                app_home: {
                    home_tab_enabled: (_k = this.props.appHome) === null || _k === void 0 ? void 0 : _k.homeTab,
                    messages_tab_enabled: (_l = this.props.appHome) === null || _l === void 0 ? void 0 : _l.messagesTab,
                    messages_tab_read_only_enabled: (_m = this.props.appHome) === null || _m === void 0 ? void 0 : _m.messagesTabReadOnly,
                },
                bot_user: this.props.botUser
                    ? {
                        display_name: (_o = this.props.botUser) === null || _o === void 0 ? void 0 : _o.displayName,
                        always_online: (_p = this.props.botUser) === null || _p === void 0 ? void 0 : _p.alwaysOnline,
                    }
                    : undefined,
                shortcuts: (_q = this.props.shortcuts) === null || _q === void 0 ? void 0 : _q.map((shortcut) => ({
                    name: shortcut.name,
                    type: shortcut.type,
                    callback_id: shortcut.callbackId,
                    description: shortcut.description,
                })),
                slash_commands: (_r = this.props.slashCommands) === null || _r === void 0 ? void 0 : _r.map((command) => ({
                    command: prefixWith('/', command.command),
                    description: command.description,
                    url: command.url,
                    usage_hint: command.usageHint,
                    should_escape: command.shouldEscape,
                })),
                workflow_steps: (_s = this.props.workflowSteps) === null || _s === void 0 ? void 0 : _s.map((step) => ({
                    name: step.name,
                    callback_id: step.callbackId,
                })),
                unfurl_domains: this.props.unfurlDomains,
            },
            oauth_config: {
                redirect_urls: (_t = this.props.oauthConfig) === null || _t === void 0 ? void 0 : _t.redirectUrls,
                scopes: {
                    bot: (_u = this.props.oauthConfig) === null || _u === void 0 ? void 0 : _u.botScopes,
                    users: (_v = this.props.oauthConfig) === null || _v === void 0 ? void 0 : _v.userScopes,
                },
            },
        };
        return aws_cdk_lib_1.Stack.of(construct).toJsonString(removeUndefined(schema));
    }
}
exports.SlackAppManifest = SlackAppManifest;
_a = JSII_RTTI_SYMBOL_1;
SlackAppManifest[_a] = { fqn: "cloudstructs.SlackAppManifest", version: "0.4.15" };
function prefixWith(prefix, string) {
    if (!string) {
        return undefined;
    }
    if (string.startsWith(prefix)) {
        return string;
    }
    return `${prefix}${string}`;
}
function validateLength(description, max, xs) {
    if (xs && !aws_cdk_lib_1.Token.isUnresolved(xs) && xs.length > max) {
        throw new Error(`Maximum length for ${description} is ${max}, got ${xs.length}: ${xs}`);
    }
}
function validateItems(description, max, xs) {
    if (xs && !aws_cdk_lib_1.Token.isUnresolved(xs) && xs.length > max) {
        throw new Error(`Maximum number of items for ${description} is ${max}, got ${xs.length}`);
    }
}
function validateColor(color) {
    if (color && !aws_cdk_lib_1.Token.isUnresolved(color) && !/^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(color)) {
        throw new Error(`Invalid hex color: ${color}`);
    }
}
function validateUrl(url, https = true) {
    if (url && !aws_cdk_lib_1.Token.isUnresolved(url)) {
        try {
            const parsed = new nodeUrl.URL(url);
            if (https && parsed.protocol !== 'https:') {
                throw new Error('Invalid protocol');
            }
        }
        catch (err) {
            throw new Error(`${url} is not a valid${https ? ' HTTPS' : ''} url`);
        }
    }
}
function removeUndefined(obj) {
    if (typeof obj === 'string') {
        return obj;
    }
    if (Array.isArray(obj)) {
        const ret = obj
            .map(v => (v && typeof v === 'object') ? removeUndefined(v) : v)
            .filter(v => !(v == null));
        return ret.length !== 0 ? ret : undefined;
    }
    const ret = Object.entries(obj)
        .map(([k, v]) => [k, v && typeof v === 'object' ? removeUndefined(v) : v])
        .reduce((a, [k, v]) => (v == null ? a : (a[k] = v, a)), {});
    return Object.keys(ret).length !== 0 ? ret : undefined;
}
//# sourceMappingURL=data:application/json;base64,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