"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlFederatedPrincipal = exports.SamlIdentityProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * (deprecated) Create a SAML identity provider.
 *
 * @deprecated use `SamlProvider` from `aws-cdk-lib/aws-iam`
 */
class SamlIdentityProvider extends constructs_1.Construct {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        const name = (_c = props.name) !== null && _c !== void 0 ? _c : `${aws_cdk_lib_1.Names.uniqueId(this)}IdentityProvider`;
        const arn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'iam',
            region: '',
            resource: 'saml-provider',
            resourceName: name,
        });
        const idp = new cr.AwsCustomResource(this, 'Resource', {
            resourceType: 'Custom::SamlIdentityProvider',
            onCreate: {
                service: 'IAM',
                action: 'createSAMLProvider',
                parameters: {
                    Name: name,
                    SAMLMetadataDocument: props.metadataDocument,
                },
                physicalResourceId: cr.PhysicalResourceId.fromResponse('SAMLProviderArn'),
            },
            onUpdate: {
                service: 'IAM',
                action: 'updateSAMLProvider',
                parameters: {
                    SAMLProviderArn: new cr.PhysicalResourceIdReference().toJSON(),
                    SAMLMetadataDocument: props.metadataDocument,
                },
                physicalResourceId: cr.PhysicalResourceId.fromResponse('SAMLProviderArn'),
            },
            onDelete: {
                service: 'IAM',
                action: 'deleteSAMLProvider',
                parameters: {
                    SAMLProviderArn: new cr.PhysicalResourceIdReference().toJSON(),
                },
            },
            policy: cr.AwsCustomResourcePolicy.fromStatements([
                new iam.PolicyStatement({
                    actions: [
                        'iam:createSAMLProvider',
                        'iam:updateSAMLProvider',
                        'iam:deleteSAMLProvider',
                    ],
                    resources: [arn],
                }),
            ]),
        });
        this.samlIdentityProviderArn = idp.getResponseField('SAMLProviderArn');
    }
}
exports.SamlIdentityProvider = SamlIdentityProvider;
_a = JSII_RTTI_SYMBOL_1;
SamlIdentityProvider[_a] = { fqn: "cloudstructs.SamlIdentityProvider", version: "0.4.15" };
/**
 * (deprecated) Principal entity that represents a SAML federated identity provider.
 *
 * @deprecated use `SamlPrincipal` from `aws-cdk-lib/aws-iam`
 */
class SamlFederatedPrincipal extends iam.FederatedPrincipal {
    /**
     * @deprecated
     */
    constructor(identityProvider) {
        super(identityProvider.samlIdentityProviderArn, {
            StringEquals: {
                'SAML:aud': 'https://signin.aws.amazon.com/saml',
            },
        }, 'sts:AssumeRoleWithSAML');
    }
}
exports.SamlFederatedPrincipal = SamlFederatedPrincipal;
_b = JSII_RTTI_SYMBOL_1;
SamlFederatedPrincipal[_b] = { fqn: "cloudstructs.SamlFederatedPrincipal", version: "0.4.15" };
//# sourceMappingURL=data:application/json;base64,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