"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailReceiver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const destinations = require("aws-cdk-lib/aws-lambda-destinations");
const logs = require("aws-cdk-lib/aws-logs");
const s3 = require("aws-cdk-lib/aws-s3");
const ses = require("aws-cdk-lib/aws-ses");
const actions = require("aws-cdk-lib/aws-ses-actions");
const sns = require("aws-cdk-lib/aws-sns");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
const s3_function_1 = require("./s3-function");
const whitelist_function_1 = require("./whitelist-function");
/**
 * Receive emails through SES, save them to S3 and invokes a Lambda function.
 *
 * @stability stable
 */
class EmailReceiver extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const receiptRule = new ses.ReceiptRule(this, 'ReceiptRule', {
            ruleSet: props.receiptRuleSet,
            recipients: props.recipients,
            after: props.afterRule,
        });
        const bucket = new s3.Bucket(this, 'Bucket', {
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [{ expiration: aws_cdk_lib_1.Duration.days(1) }],
        });
        bucket.grantRead(props.function); // Download email
        const topic = new sns.Topic(this, 'Topic');
        // Actions
        if (props.sourceWhitelist) {
            const whitelistHandler = new whitelist_function_1.WhitelistFunction(this, 'whitelist', {
                environment: {
                    SOURCE_WHITELIST: props.sourceWhitelist,
                },
                logRetention: logs.RetentionDays.ONE_MONTH,
            });
            receiptRule.addAction(new actions.Lambda({
                function: whitelistHandler,
                invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            }));
        }
        receiptRule.addAction(new actions.S3({
            bucket,
            topic,
        }));
        const s3Handler = new s3_function_1.S3Function(this, 's3', {
            logRetention: logs.RetentionDays.ONE_MONTH,
            onSuccess: new destinations.LambdaDestination(props.function, {
                responseOnly: true,
            }),
        });
        topic.addSubscription(new subscriptions.LambdaSubscription(s3Handler)); // Notify
    }
}
exports.EmailReceiver = EmailReceiver;
_a = JSII_RTTI_SYMBOL_1;
EmailReceiver[_a] = { fqn: "cloudstructs.EmailReceiver", version: "0.4.15" };
//# sourceMappingURL=data:application/json;base64,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