"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitMirror = exports.CodeCommitMirrorSourceRepository = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const codecommit = require("aws-cdk-lib/aws-codecommit");
const ec2 = require("aws-cdk-lib/aws-ec2");
const ecs = require("aws-cdk-lib/aws-ecs");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
/**
 * A source repository for AWS CodeCommit mirroring.
 *
 * @stability stable
 */
class CodeCommitMirrorSourceRepository {
    /**
     * Public GitHub repository.
     *
     * @stability stable
     */
    static gitHub(owner, name) {
        return {
            name,
            plainTextUrl: `https://github.com/${owner}/${name}`,
        };
    }
    /**
     * Private repository with HTTPS clone URL stored in a AWS Secrets Manager secret or a AWS Systems Manager secure string parameter.
     *
     * @param name the repository name.
     * @param url the secret containing the HTTPS clone URL.
     * @stability stable
     */
    static private(name, url) {
        return {
            name,
            secretUrl: url,
        };
    }
}
exports.CodeCommitMirrorSourceRepository = CodeCommitMirrorSourceRepository;
_a = JSII_RTTI_SYMBOL_1;
CodeCommitMirrorSourceRepository[_a] = { fqn: "cloudstructs.CodeCommitMirrorSourceRepository", version: "0.4.15" };
/**
 * Mirror a repository to AWS CodeCommit on schedule.
 *
 * @stability stable
 */
class CodeCommitMirror extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        const destination = new codecommit.Repository(this, 'Repository', {
            repositoryName: props.repository.name,
            description: `Mirror of ${props.repository.name}`,
        });
        const taskDefinition = new ecs.FargateTaskDefinition(this, 'TaskDefinition');
        taskDefinition.addContainer('Container', {
            image: ecs.ContainerImage.fromAsset(path.join(__dirname, '..', '..', 'assets', 'codecommit-mirror', 'docker')),
            logging: new ecs.AwsLogDriver({
                streamPrefix: props.repository.name,
                logRetention: logs.RetentionDays.TWO_MONTHS,
            }),
            environment: {
                NAME: props.repository.name,
                DESTINATION: destination.repositoryCloneUrlGrc,
                ...props.repository.plainTextUrl
                    ? { SOURCE: props.repository.plainTextUrl }
                    : {},
            },
            secrets: props.repository.secretUrl
                ? { SOURCE: props.repository.secretUrl }
                : undefined,
        });
        taskDefinition.addToTaskRolePolicy(new iam.PolicyStatement({
            actions: ['codecommit:GitPush'],
            resources: [destination.repositoryArn],
        }));
        const rule = new events.Rule(this, 'Rule', {
            schedule: (_c = props.schedule) !== null && _c !== void 0 ? _c : events.Schedule.cron({
                minute: '0',
                hour: '0',
            }),
        });
        rule.addTarget(new targets.EcsTask({
            cluster: props.cluster,
            taskDefinition,
            subnetSelection: (_d = props.subnetSelection) !== null && _d !== void 0 ? _d : { subnetType: ec2.SubnetType.PUBLIC },
        }));
    }
}
exports.CodeCommitMirror = CodeCommitMirror;
_b = JSII_RTTI_SYMBOL_1;
CodeCommitMirror[_b] = { fqn: "cloudstructs.CodeCommitMirror", version: "0.4.15" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY29kZWNvbW1pdC1taXJyb3IvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2QkFBNkI7QUFDN0IseURBQXlEO0FBQ3pELDJDQUEyQztBQUMzQywyQ0FBMkM7QUFDM0MsaURBQWlEO0FBQ2pELDBEQUEwRDtBQUMxRCwyQ0FBMkM7QUFDM0MsNkNBQTZDO0FBQzdDLDJDQUF1Qzs7Ozs7O0FBa0J2QyxNQUFzQixnQ0FBZ0M7Ozs7OztJQUU3QyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQWEsRUFBRSxJQUFZO1FBQzlDLE9BQU87WUFDTCxJQUFJO1lBQ0osWUFBWSxFQUFFLHNCQUFzQixLQUFLLElBQUksSUFBSSxFQUFFO1NBQ3BELENBQUM7SUFDSixDQUFDOzs7Ozs7OztJQUdNLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBWSxFQUFFLEdBQWU7UUFDakQsT0FBTztZQUNMLElBQUk7WUFDSixTQUFTLEVBQUUsR0FBRztTQUNmLENBQUM7SUFDSixDQUFDOztBQWZILDRFQXlCQzs7Ozs7Ozs7QUFHRCxNQUFhLGdCQUFpQixTQUFRLHNCQUFTOzs7O0lBQzdDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7O1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxXQUFXLEdBQUcsSUFBSSxVQUFVLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUU7WUFDaEUsY0FBYyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSTtZQUNyQyxXQUFXLEVBQUUsYUFBYSxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRTtTQUNsRCxDQUFDLENBQUM7UUFFSCxNQUFNLGNBQWMsR0FBRyxJQUFJLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztRQUU3RSxjQUFjLENBQUMsWUFBWSxDQUFDLFdBQVcsRUFBRTtZQUN2QyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsbUJBQW1CLEVBQUUsUUFBUSxDQUFDLENBQUM7WUFDOUcsT0FBTyxFQUFFLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQztnQkFDNUIsWUFBWSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSTtnQkFDbkMsWUFBWSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsVUFBVTthQUM1QyxDQUFDO1lBQ0YsV0FBVyxFQUFFO2dCQUNYLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUk7Z0JBQzNCLFdBQVcsRUFBRSxXQUFXLENBQUMscUJBQXFCO2dCQUM5QyxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUMsWUFBWTtvQkFDOUIsQ0FBQyxDQUFDLEVBQUUsTUFBTSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFO29CQUMzQyxDQUFDLENBQUMsRUFBRTthQUNQO1lBQ0QsT0FBTyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsU0FBUztnQkFDakMsQ0FBQyxDQUFDLEVBQUUsTUFBTSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsU0FBUyxFQUFFO2dCQUN4QyxDQUFDLENBQUMsU0FBUztTQUNkLENBQUMsQ0FBQztRQUVILGNBQWMsQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDekQsT0FBTyxFQUFFLENBQUMsb0JBQW9CLENBQUM7WUFDL0IsU0FBUyxFQUFFLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQztTQUN2QyxDQUFDLENBQUMsQ0FBQztRQUVKLE1BQU0sSUFBSSxHQUFHLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsTUFBTSxFQUFFO1lBQ3pDLFFBQVEsUUFBRSxLQUFLLENBQUMsUUFBUSxtQ0FBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQztnQkFDL0MsTUFBTSxFQUFFLEdBQUc7Z0JBQ1gsSUFBSSxFQUFFLEdBQUc7YUFDVixDQUFDO1NBQ0gsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxPQUFPLENBQUM7WUFDakMsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLGNBQWM7WUFDZCxlQUFlLFFBQUUsS0FBSyxDQUFDLGVBQWUsbUNBQUksRUFBRSxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxNQUFNLEVBQUU7U0FDaEYsQ0FBQyxDQUFDLENBQUM7SUFDTixDQUFDOztBQTlDSCw0Q0ErQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgY29kZWNvbW1pdCBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY29kZWNvbW1pdCc7XG5pbXBvcnQgKiBhcyBlYzIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBlY3MgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjcyc7XG5pbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWV2ZW50cyc7XG5pbXBvcnQgKiBhcyB0YXJnZXRzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1ldmVudHMtdGFyZ2V0cyc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsb2dzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1sb2dzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBDb2RlQ29tbWl0TWlycm9yUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVwb3NpdG9yeTogQ29kZUNvbW1pdE1pcnJvclNvdXJjZVJlcG9zaXRvcnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjbHVzdGVyOiBlY3MuSUNsdXN0ZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzY2hlZHVsZT86IGV2ZW50cy5TY2hlZHVsZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN1Ym5ldFNlbGVjdGlvbj86IGVjMi5TdWJuZXRTZWxlY3Rpb247XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQ29kZUNvbW1pdE1pcnJvclNvdXJjZVJlcG9zaXRvcnkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBnaXRIdWIob3duZXI6IHN0cmluZywgbmFtZTogc3RyaW5nKTogQ29kZUNvbW1pdE1pcnJvclNvdXJjZVJlcG9zaXRvcnkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lLFxuICAgICAgcGxhaW5UZXh0VXJsOiBgaHR0cHM6Ly9naXRodWIuY29tLyR7b3duZXJ9LyR7bmFtZX1gLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHByaXZhdGUobmFtZTogc3RyaW5nLCB1cmw6IGVjcy5TZWNyZXQpOiBDb2RlQ29tbWl0TWlycm9yU291cmNlUmVwb3NpdG9yeSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWUsXG4gICAgICBzZWNyZXRVcmw6IHVybCxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBwbGFpblRleHRVcmw/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHNlY3JldFVybD86IGVjcy5TZWNyZXQ7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIENvZGVDb21taXRNaXJyb3IgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ29kZUNvbW1pdE1pcnJvclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGRlc3RpbmF0aW9uID0gbmV3IGNvZGVjb21taXQuUmVwb3NpdG9yeSh0aGlzLCAnUmVwb3NpdG9yeScsIHtcbiAgICAgIHJlcG9zaXRvcnlOYW1lOiBwcm9wcy5yZXBvc2l0b3J5Lm5hbWUsXG4gICAgICBkZXNjcmlwdGlvbjogYE1pcnJvciBvZiAke3Byb3BzLnJlcG9zaXRvcnkubmFtZX1gLFxuICAgIH0pO1xuXG4gICAgY29uc3QgdGFza0RlZmluaXRpb24gPSBuZXcgZWNzLkZhcmdhdGVUYXNrRGVmaW5pdGlvbih0aGlzLCAnVGFza0RlZmluaXRpb24nKTtcblxuICAgIHRhc2tEZWZpbml0aW9uLmFkZENvbnRhaW5lcignQ29udGFpbmVyJywge1xuICAgICAgaW1hZ2U6IGVjcy5Db250YWluZXJJbWFnZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJy4uJywgJy4uJywgJ2Fzc2V0cycsICdjb2RlY29tbWl0LW1pcnJvcicsICdkb2NrZXInKSksXG4gICAgICBsb2dnaW5nOiBuZXcgZWNzLkF3c0xvZ0RyaXZlcih7XG4gICAgICAgIHN0cmVhbVByZWZpeDogcHJvcHMucmVwb3NpdG9yeS5uYW1lLFxuICAgICAgICBsb2dSZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5UV09fTU9OVEhTLFxuICAgICAgfSksXG4gICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICBOQU1FOiBwcm9wcy5yZXBvc2l0b3J5Lm5hbWUsXG4gICAgICAgIERFU1RJTkFUSU9OOiBkZXN0aW5hdGlvbi5yZXBvc2l0b3J5Q2xvbmVVcmxHcmMsXG4gICAgICAgIC4uLnByb3BzLnJlcG9zaXRvcnkucGxhaW5UZXh0VXJsXG4gICAgICAgICAgPyB7IFNPVVJDRTogcHJvcHMucmVwb3NpdG9yeS5wbGFpblRleHRVcmwgfVxuICAgICAgICAgIDoge30sXG4gICAgICB9LFxuICAgICAgc2VjcmV0czogcHJvcHMucmVwb3NpdG9yeS5zZWNyZXRVcmxcbiAgICAgICAgPyB7IFNPVVJDRTogcHJvcHMucmVwb3NpdG9yeS5zZWNyZXRVcmwgfVxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICB9KTtcblxuICAgIHRhc2tEZWZpbml0aW9uLmFkZFRvVGFza1JvbGVQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydjb2RlY29tbWl0OkdpdFB1c2gnXSxcbiAgICAgIHJlc291cmNlczogW2Rlc3RpbmF0aW9uLnJlcG9zaXRvcnlBcm5dLFxuICAgIH0pKTtcblxuICAgIGNvbnN0IHJ1bGUgPSBuZXcgZXZlbnRzLlJ1bGUodGhpcywgJ1J1bGUnLCB7XG4gICAgICBzY2hlZHVsZTogcHJvcHMuc2NoZWR1bGUgPz8gZXZlbnRzLlNjaGVkdWxlLmNyb24oe1xuICAgICAgICBtaW51dGU6ICcwJyxcbiAgICAgICAgaG91cjogJzAnLFxuICAgICAgfSksXG4gICAgfSk7XG5cbiAgICBydWxlLmFkZFRhcmdldChuZXcgdGFyZ2V0cy5FY3NUYXNrKHtcbiAgICAgIGNsdXN0ZXI6IHByb3BzLmNsdXN0ZXIsXG4gICAgICB0YXNrRGVmaW5pdGlvbixcbiAgICAgIHN1Ym5ldFNlbGVjdGlvbjogcHJvcHMuc3VibmV0U2VsZWN0aW9uID8/IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuUFVCTElDIH0sXG4gICAgfSkpO1xuICB9XG59XG4iXX0=