# -*- coding: utf-8 -*-

"""
GNU General Public License v3.0 (GPL v3)
Copyright (c) 2020-2021 WardPearce
Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
"""

from starlette.endpoints import HTTPEndpoint
from starlette.authentication import requires
from starlette.requests import Request

from webargs import fields
from webargs_starlette import use_args

from ...responses import response, error_response
from ...resources import Sessions


class AutoSetupAPI(HTTPEndpoint):
    @use_args({"host": fields.IPv4(required=True),
               "user": fields.String(required=True),
               "password": fields.String(required=True),
               "port": fields.Integer(),
               "csgo_folder": fields.String(missing="")})
    @requires(["is_owner", "active_subscription"])
    async def post(self, request: Request, paramters: dict) -> response:
        """Used to automatically upload plugin files over FTP.

        Parameters
        ----------
        request : Request
        paramters : dict

        Returns
        -------
        response
        """

        # Temp
        return error_response("Not implemented")

        async with Sessions.ftp.context(**paramters) as _:
            pass

        return response()
