# Localization Sync
This is a python script that downloads localization strings and CI color information from a public [Google Sheet](https://docs.google.com/spreadsheets) and generates resource files for iOS and Android projects.

![Vizualization of the workflow](Resources/workflow.jpg)

## Installation

This uses the [pip](https://packaging.python.org/en/latest/key_projects/#pip) package manager for Python packages ([see guide](https://packaging.python.org/en/latest/tutorials/installing-packages/)). It depends on the [pyexcel-ods](https://pypi.org/project/pyexcel-ods/) package which will be installed alongsite automatically when you run:

    pip install localization-sync

Hint: It could be that you need to use `pip3` command instead of `pip`.

## Prerequisites

### 1. Create a Google Sheet

Create a Google Sheet document with sheets like [these](https://docs.google.com/spreadsheets/d/1672QPWDsxBtaX5hc5QgZhqBwLADMnPVEv7-wLB3g-ug):

![Example of a L10n table](Resources/sheet_l10n.png)
![Example of a colors table](Resources/sheet_colors.png)

Mind to __not__ add extra columns or rows at the top/left of your tables. I you need to do so, use `keyRow`/`keyColumn` parameters in config to inset the parsing of the table.

### 2. Publish

Publish the sheeet to the web by pressing __File -> Publish to the web__. Select __Whole Document__ and __Website__. This enables the script do export the contents of the sheet as ODS file.

_Note_: We are using the export instead of the JSON API. Because this way there is no need for creating an API Key and using OAuth on the client (your) side.

### 3. Get the ID

Find the ID of your document by copying it from your browsers address bar.

![sheet_url.png](Resources/sheet_url.png)

## Usage

Create a `data_sync.config.json` in your project and populate it with the contents of the [example config](data_sync.config.json). Replace the `sheetId` with your own. You can modify the other settings to fit the needs of your project.

Then open a terminal at your project path and run `l10n_sync`. Look for your newly created resource files.

You can also copy [data_sync.py](Sources/data_sync.py) to your project and then run `python3 data_sync.py` when your config file is ready.

## Example

Have a look into the [Output folder](Output) for some example files generated by using the provided [configuration file](data_sync.config.json).
