import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of application credential source ID's.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#application_credential_source_ids Target#application_credential_source_ids}
    */
    readonly applicationCredentialSourceIds?: string[];
    /**
    * The default port for this target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#default_port Target#default_port}
    */
    readonly defaultPort?: number;
    /**
    * The target description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#description Target#description}
    */
    readonly description?: string;
    /**
    * A list of host source ID's.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#host_source_ids Target#host_source_ids}
    */
    readonly hostSourceIds?: string[];
    /**
    * The target name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#name Target#name}
    */
    readonly name?: string;
    /**
    * The scope ID in which the resource is created. Defaults to the provider's `default_scope` if unset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#scope_id Target#scope_id}
    */
    readonly scopeId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#session_connection_limit Target#session_connection_limit}
    */
    readonly sessionConnectionLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#session_max_seconds Target#session_max_seconds}
    */
    readonly sessionMaxSeconds?: number;
    /**
    * The target resource type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#type Target#type}
    */
    readonly type: string;
    /**
    * Boolean expression to filter the workers for this target
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/target#worker_filter Target#worker_filter}
    */
    readonly workerFilter?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/target boundary_target}
*/
export declare class Target extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/target boundary_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetConfig
    */
    constructor(scope: Construct, id: string, config: TargetConfig);
    private _applicationCredentialSourceIds?;
    get applicationCredentialSourceIds(): string[];
    set applicationCredentialSourceIds(value: string[]);
    resetApplicationCredentialSourceIds(): void;
    get applicationCredentialSourceIdsInput(): string[] | undefined;
    private _defaultPort?;
    get defaultPort(): number;
    set defaultPort(value: number);
    resetDefaultPort(): void;
    get defaultPortInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hostSourceIds?;
    get hostSourceIds(): string[];
    set hostSourceIds(value: string[]);
    resetHostSourceIds(): void;
    get hostSourceIdsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _sessionConnectionLimit?;
    get sessionConnectionLimit(): number;
    set sessionConnectionLimit(value: number);
    resetSessionConnectionLimit(): void;
    get sessionConnectionLimitInput(): number | undefined;
    private _sessionMaxSeconds?;
    get sessionMaxSeconds(): number;
    set sessionMaxSeconds(value: number);
    resetSessionMaxSeconds(): void;
    get sessionMaxSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _workerFilter?;
    get workerFilter(): string;
    set workerFilter(value: string);
    resetWorkerFilter(): void;
    get workerFilterInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=target.d.ts.map