import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set, when a new scope is created, the provider will not disable the functionality that automatically creates a role in the new scope and gives permissions to manage the scope to the provider's user. Marking this true makes for simpler HCL but results in role resources that are unmanaged by Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/scope#auto_create_admin_role Scope#auto_create_admin_role}
    */
    readonly autoCreateAdminRole?: boolean | cdktf.IResolvable;
    /**
    * Only relevant when creating an org scope. If set, when a new scope is created, the provider will not disable the functionality that automatically creates a role in the new scope and gives listing of scopes and auth methods and the ability to authenticate to the anonymous user. Marking this true makes for simpler HCL but results in role resources that are unmanaged by Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/scope#auto_create_default_role Scope#auto_create_default_role}
    */
    readonly autoCreateDefaultRole?: boolean | cdktf.IResolvable;
    /**
    * The scope description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/scope#description Scope#description}
    */
    readonly description?: string;
    /**
    * Indicates that the scope containing this value is the global scope, which triggers some specialized behavior to allow it to be imported and managed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/scope#global_scope Scope#global_scope}
    */
    readonly globalScope?: boolean | cdktf.IResolvable;
    /**
    * The scope name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/scope#name Scope#name}
    */
    readonly name?: string;
    /**
    * The scope ID containing the sub scope resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/scope#scope_id Scope#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/scope boundary_scope}
*/
export declare class Scope extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/scope boundary_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ScopeConfig
    */
    constructor(scope: Construct, id: string, config: ScopeConfig);
    private _autoCreateAdminRole?;
    get autoCreateAdminRole(): boolean | cdktf.IResolvable;
    set autoCreateAdminRole(value: boolean | cdktf.IResolvable);
    resetAutoCreateAdminRole(): void;
    get autoCreateAdminRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _autoCreateDefaultRole?;
    get autoCreateDefaultRole(): boolean | cdktf.IResolvable;
    set autoCreateDefaultRole(value: boolean | cdktf.IResolvable);
    resetAutoCreateDefaultRole(): void;
    get autoCreateDefaultRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _globalScope?;
    get globalScope(): boolean | cdktf.IResolvable;
    set globalScope(value: boolean | cdktf.IResolvable);
    resetGlobalScope(): void;
    get globalScopeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=scope.d.ts.map