import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Indicates that the role containing this value is the default role (that is, has the id 'r_default'), which triggers some specialized behavior to allow it to be imported and managed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#default_role Role#default_role}
    */
    readonly defaultRole?: boolean | cdktf.IResolvable;
    /**
    * The role description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#description Role#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#grant_scope_id Role#grant_scope_id}
    */
    readonly grantScopeId?: string;
    /**
    *  A list of stringified grants for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#grant_strings Role#grant_strings}
    */
    readonly grantStrings?: string[];
    /**
    * The role name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#name Role#name}
    */
    readonly name?: string;
    /**
    * A list of principal (user or group) IDs to add as principals on the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#principal_ids Role#principal_ids}
    */
    readonly principalIds?: string[];
    /**
    * The scope ID in which the resource is created. Defaults to the provider's `default_scope` if unset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/role#scope_id Role#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/role boundary_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/role boundary_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _defaultRole?;
    get defaultRole(): boolean | cdktf.IResolvable;
    set defaultRole(value: boolean | cdktf.IResolvable);
    resetDefaultRole(): void;
    get defaultRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _grantScopeId?;
    get grantScopeId(): string;
    set grantScopeId(value: string);
    resetGrantScopeId(): void;
    get grantScopeIdInput(): string | undefined;
    private _grantStrings?;
    get grantStrings(): string[];
    set grantStrings(value: string[]);
    resetGrantStrings(): void;
    get grantStringsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalIds?;
    get principalIds(): string[];
    set principalIds(value: string[]);
    resetPrincipalIds(): void;
    get principalIdsInput(): string[] | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=role.d.ts.map