import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource ID for the auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/managed_group#auth_method_id ManagedGroup#auth_method_id}
    */
    readonly authMethodId: string;
    /**
    * The managed group description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/managed_group#description ManagedGroup#description}
    */
    readonly description?: string;
    /**
    * Boolean expression to filter the workers for this managed group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/managed_group#filter ManagedGroup#filter}
    */
    readonly filter: string;
    /**
    * The managed group name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/managed_group#name ManagedGroup#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/managed_group boundary_managed_group}
*/
export declare class ManagedGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_managed_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/managed_group boundary_managed_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedGroupConfig
    */
    constructor(scope: Construct, id: string, config: ManagedGroupConfig);
    private _authMethodId?;
    get authMethodId(): string;
    set authMethodId(value: string);
    get authMethodIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=managed-group.d.ts.map