import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostCatalogStaticConfig extends cdktf.TerraformMetaArguments {
    /**
    * The host catalog description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_static#description HostCatalogStatic#description}
    */
    readonly description?: string;
    /**
    * The host catalog name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_static#name HostCatalogStatic#name}
    */
    readonly name?: string;
    /**
    * The scope ID in which the resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_static#scope_id HostCatalogStatic#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_static boundary_host_catalog_static}
*/
export declare class HostCatalogStatic extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_host_catalog_static";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_static boundary_host_catalog_static} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostCatalogStaticConfig
    */
    constructor(scope: Construct, id: string, config: HostCatalogStaticConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=host-catalog-static.d.ts.map