"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostCatalogPlugin = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_plugin boundary_host_catalog_plugin}
*/
class HostCatalogPlugin extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_plugin boundary_host_catalog_plugin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostCatalogPluginConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'boundary_host_catalog_plugin',
            terraformGeneratorMetadata: {
                providerName: 'boundary',
                providerVersion: '1.0.7',
                providerVersionConstraint: '~> 1.0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._attributesJson = config.attributesJson;
        this._description = config.description;
        this._internalForceUpdate = config.internalForceUpdate;
        this._internalHmacUsedForSecretsConfigHmac = config.internalHmacUsedForSecretsConfigHmac;
        this._internalSecretsConfigHmac = config.internalSecretsConfigHmac;
        this._name = config.name;
        this._pluginId = config.pluginId;
        this._pluginName = config.pluginName;
        this._scopeId = config.scopeId;
        this._secretsHmac = config.secretsHmac;
        this._secretsJson = config.secretsJson;
    }
    get attributesJson() {
        return this.getStringAttribute('attributes_json');
    }
    set attributesJson(value) {
        this._attributesJson = value;
    }
    resetAttributesJson() {
        this._attributesJson = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get attributesJsonInput() {
        return this._attributesJson;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get internalForceUpdate() {
        return this.getStringAttribute('internal_force_update');
    }
    set internalForceUpdate(value) {
        this._internalForceUpdate = value;
    }
    resetInternalForceUpdate() {
        this._internalForceUpdate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalForceUpdateInput() {
        return this._internalForceUpdate;
    }
    get internalHmacUsedForSecretsConfigHmac() {
        return this.getStringAttribute('internal_hmac_used_for_secrets_config_hmac');
    }
    set internalHmacUsedForSecretsConfigHmac(value) {
        this._internalHmacUsedForSecretsConfigHmac = value;
    }
    resetInternalHmacUsedForSecretsConfigHmac() {
        this._internalHmacUsedForSecretsConfigHmac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalHmacUsedForSecretsConfigHmacInput() {
        return this._internalHmacUsedForSecretsConfigHmac;
    }
    get internalSecretsConfigHmac() {
        return this.getStringAttribute('internal_secrets_config_hmac');
    }
    set internalSecretsConfigHmac(value) {
        this._internalSecretsConfigHmac = value;
    }
    resetInternalSecretsConfigHmac() {
        this._internalSecretsConfigHmac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalSecretsConfigHmacInput() {
        return this._internalSecretsConfigHmac;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get pluginId() {
        return this.getStringAttribute('plugin_id');
    }
    set pluginId(value) {
        this._pluginId = value;
    }
    resetPluginId() {
        this._pluginId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pluginIdInput() {
        return this._pluginId;
    }
    get pluginName() {
        return this.getStringAttribute('plugin_name');
    }
    set pluginName(value) {
        this._pluginName = value;
    }
    resetPluginName() {
        this._pluginName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pluginNameInput() {
        return this._pluginName;
    }
    get scopeId() {
        return this.getStringAttribute('scope_id');
    }
    set scopeId(value) {
        this._scopeId = value;
    }
    // Temporarily expose input value. Use with caution.
    get scopeIdInput() {
        return this._scopeId;
    }
    get secretsHmac() {
        return this.getStringAttribute('secrets_hmac');
    }
    set secretsHmac(value) {
        this._secretsHmac = value;
    }
    resetSecretsHmac() {
        this._secretsHmac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretsHmacInput() {
        return this._secretsHmac;
    }
    get secretsJson() {
        return this.getStringAttribute('secrets_json');
    }
    set secretsJson(value) {
        this._secretsJson = value;
    }
    resetSecretsJson() {
        this._secretsJson = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretsJsonInput() {
        return this._secretsJson;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            attributes_json: cdktf.stringToTerraform(this._attributesJson),
            description: cdktf.stringToTerraform(this._description),
            internal_force_update: cdktf.stringToTerraform(this._internalForceUpdate),
            internal_hmac_used_for_secrets_config_hmac: cdktf.stringToTerraform(this._internalHmacUsedForSecretsConfigHmac),
            internal_secrets_config_hmac: cdktf.stringToTerraform(this._internalSecretsConfigHmac),
            name: cdktf.stringToTerraform(this._name),
            plugin_id: cdktf.stringToTerraform(this._pluginId),
            plugin_name: cdktf.stringToTerraform(this._pluginName),
            scope_id: cdktf.stringToTerraform(this._scopeId),
            secrets_hmac: cdktf.stringToTerraform(this._secretsHmac),
            secrets_json: cdktf.stringToTerraform(this._secretsJson),
        };
    }
}
exports.HostCatalogPlugin = HostCatalogPlugin;
_a = JSII_RTTI_SYMBOL_1;
HostCatalogPlugin[_a] = { fqn: "hashicorp_boundary.HostCatalogPlugin", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
HostCatalogPlugin.tfResourceType = "boundary_host_catalog_plugin";
//# sourceMappingURL=data:application/json;base64,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