import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The group description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/group#description Group#description}
    */
    readonly description?: string;
    /**
    * Resource IDs for group members, these are most likely boundary users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/group#member_ids Group#member_ids}
    */
    readonly memberIds?: string[];
    /**
    * The group name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/group#name Group#name}
    */
    readonly name?: string;
    /**
    * The scope ID in which the resource is created. Defaults to the provider's `default_scope` if unset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/group#scope_id Group#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/group boundary_group}
*/
export declare class Group extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/group boundary_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _memberIds?;
    get memberIds(): string[];
    set memberIds(value: string[]);
    resetMemberIds(): void;
    get memberIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=group.d.ts.map