import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialStoreVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * The address to Vault server. This should be a complete URL such as 'https://127.0.0.1:8200'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#address CredentialStoreVault#address}
    */
    readonly address: string;
    /**
    * A PEM-encoded CA certificate to verify the Vault server's TLS certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#ca_cert CredentialStoreVault#ca_cert}
    */
    readonly caCert?: string;
    /**
    * A PEM-encoded client certificate to use for TLS authentication to the Vault server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#client_certificate CredentialStoreVault#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * A PEM-encoded private key matching the client certificate from 'client_certificate'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#client_certificate_key CredentialStoreVault#client_certificate_key}
    */
    readonly clientCertificateKey?: string;
    /**
    * The Vault credential store description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#description CredentialStoreVault#description}
    */
    readonly description?: string;
    /**
    * The Vault credential store name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#name CredentialStoreVault#name}
    */
    readonly name?: string;
    /**
    * The namespace within Vault to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#namespace CredentialStoreVault#namespace}
    */
    readonly namespace?: string;
    /**
    * The scope for this credential store.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#scope_id CredentialStoreVault#scope_id}
    */
    readonly scopeId: string;
    /**
    * Name to use as the SNI host when connecting to Vault via TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#tls_server_name CredentialStoreVault#tls_server_name}
    */
    readonly tlsServerName?: string;
    /**
    * Whether or not to skip TLS verification.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#tls_skip_verify CredentialStoreVault#tls_skip_verify}
    */
    readonly tlsSkipVerify?: boolean | cdktf.IResolvable;
    /**
    * A token used for accessing Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault#token CredentialStoreVault#token}
    */
    readonly token: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault boundary_credential_store_vault}
*/
export declare class CredentialStoreVault extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_store_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_vault boundary_credential_store_vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialStoreVaultConfig
    */
    constructor(scope: Construct, id: string, config: CredentialStoreVaultConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _caCert?;
    get caCert(): string;
    set caCert(value: string);
    resetCaCert(): void;
    get caCertInput(): string | undefined;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientCertificateKey?;
    get clientCertificateKey(): string;
    set clientCertificateKey(value: string);
    resetClientCertificateKey(): void;
    get clientCertificateKeyInput(): string | undefined;
    get clientCertificateKeyHmac(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _tlsServerName?;
    get tlsServerName(): string;
    set tlsServerName(value: string);
    resetTlsServerName(): void;
    get tlsServerNameInput(): string | undefined;
    private _tlsSkipVerify?;
    get tlsSkipVerify(): boolean | cdktf.IResolvable;
    set tlsSkipVerify(value: boolean | cdktf.IResolvable);
    resetTlsSkipVerify(): void;
    get tlsSkipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    get tokenHmac(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=credential-store-vault.d.ts.map