"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoundaryProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary boundary}
*/
class BoundaryProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary boundary} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BoundaryProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'boundary',
            terraformGeneratorMetadata: {
                providerName: 'boundary',
                providerVersion: '1.0.7',
                providerVersionConstraint: '~> 1.0.7'
            },
            terraformProviderSource: 'hashicorp/boundary'
        });
        this._addr = config.addr;
        this._authMethodId = config.authMethodId;
        this._passwordAuthMethodLoginName = config.passwordAuthMethodLoginName;
        this._passwordAuthMethodPassword = config.passwordAuthMethodPassword;
        this._recoveryKmsHcl = config.recoveryKmsHcl;
        this._tlsInsecure = config.tlsInsecure;
        this._token = config.token;
        this._alias = config.alias;
    }
    get addr() {
        return this._addr;
    }
    set addr(value) {
        this._addr = value;
    }
    // Temporarily expose input value. Use with caution.
    get addrInput() {
        return this._addr;
    }
    get authMethodId() {
        return this._authMethodId;
    }
    set authMethodId(value) {
        this._authMethodId = value;
    }
    resetAuthMethodId() {
        this._authMethodId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authMethodIdInput() {
        return this._authMethodId;
    }
    get passwordAuthMethodLoginName() {
        return this._passwordAuthMethodLoginName;
    }
    set passwordAuthMethodLoginName(value) {
        this._passwordAuthMethodLoginName = value;
    }
    resetPasswordAuthMethodLoginName() {
        this._passwordAuthMethodLoginName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthMethodLoginNameInput() {
        return this._passwordAuthMethodLoginName;
    }
    get passwordAuthMethodPassword() {
        return this._passwordAuthMethodPassword;
    }
    set passwordAuthMethodPassword(value) {
        this._passwordAuthMethodPassword = value;
    }
    resetPasswordAuthMethodPassword() {
        this._passwordAuthMethodPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthMethodPasswordInput() {
        return this._passwordAuthMethodPassword;
    }
    get recoveryKmsHcl() {
        return this._recoveryKmsHcl;
    }
    set recoveryKmsHcl(value) {
        this._recoveryKmsHcl = value;
    }
    resetRecoveryKmsHcl() {
        this._recoveryKmsHcl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoveryKmsHclInput() {
        return this._recoveryKmsHcl;
    }
    get tlsInsecure() {
        return this._tlsInsecure;
    }
    set tlsInsecure(value) {
        this._tlsInsecure = value;
    }
    resetTlsInsecure() {
        this._tlsInsecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsInsecureInput() {
        return this._tlsInsecure;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            addr: cdktf.stringToTerraform(this._addr),
            auth_method_id: cdktf.stringToTerraform(this._authMethodId),
            password_auth_method_login_name: cdktf.stringToTerraform(this._passwordAuthMethodLoginName),
            password_auth_method_password: cdktf.stringToTerraform(this._passwordAuthMethodPassword),
            recovery_kms_hcl: cdktf.stringToTerraform(this._recoveryKmsHcl),
            tls_insecure: cdktf.booleanToTerraform(this._tlsInsecure),
            token: cdktf.stringToTerraform(this._token),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.BoundaryProvider = BoundaryProvider;
_a = JSII_RTTI_SYMBOL_1;
BoundaryProvider[_a] = { fqn: "hashicorp_boundary.BoundaryProvider", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
BoundaryProvider.tfResourceType = "boundary";
//# sourceMappingURL=data:application/json;base64,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