import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BoundaryProviderConfig {
    /**
    * The base url of the Boundary API, e.g. "http://127.0.0.1:9200". If not set, it will be read from the "BOUNDARY_ADDR" env var.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#addr BoundaryProvider#addr}
    */
    readonly addr: string;
    /**
    * The auth method ID e.g. ampw_1234567890
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#auth_method_id BoundaryProvider#auth_method_id}
    */
    readonly authMethodId?: string;
    /**
    * The auth method login name for password-style auth methods
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#password_auth_method_login_name BoundaryProvider#password_auth_method_login_name}
    */
    readonly passwordAuthMethodLoginName?: string;
    /**
    * The auth method password for password-style auth methods
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#password_auth_method_password BoundaryProvider#password_auth_method_password}
    */
    readonly passwordAuthMethodPassword?: string;
    /**
    * Can be a heredoc string or a path on disk. If set, the string/file will be parsed as HCL and used with the recovery KMS mechanism. While this is set, it will override any other authentication information; the KMS mechanism will always be used. See Boundary's KMS docs for examples: https://boundaryproject.io/docs/configuration/kms
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#recovery_kms_hcl BoundaryProvider#recovery_kms_hcl}
    */
    readonly recoveryKmsHcl?: string;
    /**
    * When set to true, does not validate the Boundary API endpoint certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#tls_insecure BoundaryProvider#tls_insecure}
    */
    readonly tlsInsecure?: boolean | cdktf.IResolvable;
    /**
    * The Boundary token to use, as a string or path on disk containing just the string. If set, the token read here will be used in place of authenticating with the auth method specified in "auth_method_id", although the recovery KMS mechanism will still override this. Can also be set with the BOUNDARY_TOKEN environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#token BoundaryProvider#token}
    */
    readonly token?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary#alias BoundaryProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary boundary}
*/
export declare class BoundaryProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "boundary";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary boundary} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BoundaryProviderConfig
    */
    constructor(scope: Construct, id: string, config: BoundaryProviderConfig);
    private _addr?;
    get addr(): string | undefined;
    set addr(value: string | undefined);
    get addrInput(): string | undefined;
    private _authMethodId?;
    get authMethodId(): string | undefined;
    set authMethodId(value: string | undefined);
    resetAuthMethodId(): void;
    get authMethodIdInput(): string | undefined;
    private _passwordAuthMethodLoginName?;
    get passwordAuthMethodLoginName(): string | undefined;
    set passwordAuthMethodLoginName(value: string | undefined);
    resetPasswordAuthMethodLoginName(): void;
    get passwordAuthMethodLoginNameInput(): string | undefined;
    private _passwordAuthMethodPassword?;
    get passwordAuthMethodPassword(): string | undefined;
    set passwordAuthMethodPassword(value: string | undefined);
    resetPasswordAuthMethodPassword(): void;
    get passwordAuthMethodPasswordInput(): string | undefined;
    private _recoveryKmsHcl?;
    get recoveryKmsHcl(): string | undefined;
    set recoveryKmsHcl(value: string | undefined);
    resetRecoveryKmsHcl(): void;
    get recoveryKmsHclInput(): string | undefined;
    private _tlsInsecure?;
    get tlsInsecure(): boolean | cdktf.IResolvable | undefined;
    set tlsInsecure(value: boolean | cdktf.IResolvable | undefined);
    resetTlsInsecure(): void;
    get tlsInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=boundary-provider.d.ts.map