# adapted from fast.ai 

import json, fire, re, os.path
import os.path
import re


def get_notebook_path():
    """
    Return the full path of the jupyter notebook.
    """
    return os.path.join(os.getcwd(), 'etl.ipynb')


def is_export(cell):
    if cell['cell_type'] != 'code': return False
    src = cell['source']
    if len(src) == 0 or len(src[0]) < 7: return False
    return re.match(r'^\s*#\s*export\s*$', src[0], re.IGNORECASE) is not None


def notebook2script():
    fname = get_notebook_path()
    main_dic = json.load(open(fname,'r', encoding="utf-8"))
    cells = main_dic['cells']
    code_cells = [c for c in cells if is_export(c)]
    module = '''
        ##########################################################
        ### THIS FILE WAS AUTOGENERATED FROM JUPYTER NOTEBOOK  ###
        ##########################################################\n\n'''
    for cell in code_cells: module += ''.join(cell['source'][1:]) + '\n\n'
    fname = os.path.splitext(fname)[0]
    fname_out = f'{fname}.py'
    # remove trailing spaces
    module = re.sub(r' +$', '', module, flags=re.MULTILINE)
    with open(fname_out,'w', encoding="utf-8") as f:
        f.write(module[:-2])
    print(f"Converted to {fname_out}")


if __name__ == '__main__':
    fire.Fire(notebook2script)
