from enum import Enum


class ParamTypes(Enum):
    STRING = 1
    INTEGER = 2
    BOOLEAN = 3
    DOUBLE = 4
    DATE_TIME = 5
    BASE64 = 6
    DB = 9


class SystemFields(Enum):
    OBJECT_ID = 1100
    OBJECT_COUNT = 1101
    OBJECT_FLAGS = 1102
    OBJECT_AVID = 1103
    OBJECT_AVDATE = 1104
    OBJECT_CRID = 1105
    OBJECT_CRDATE = 1106
    OBJECT_TIME = 1107
    OBJECT_MAIN = 1108
    OBJECT_CO = 1109
    OBJECT_MEDDOCID = 1110
    OBJECT_MEDDIAID = 1111
    OBJECT_MEDDOCNA = 1112
    OBJECT_MEDDIANA = 1113
    OBJECT_LINKS = 1114
    OBJECT_VERID = 1115
    OBJECT_LOCKUSER = 1116
    OBJECT_SYSTEMID = 1117
    OBJECT_MODIFYTIME = 1118
    OBJECT_MODIFYUSER = 1119
    OBJECT_FOREIGNID = 1124
    OBJECT_USERGUID = 1125
    OBJECT_DELETED = 1126
    OBJECT_INDEXHISTFLAGS = 1127
    OBJECT_DOCHISTFLAGS = 1128
    OBJECT_OSSD = 1129
    OBJECT_MIMETYPEID = 1900
    OBJECT_FILESIZE = 1902
    OBJECT_RETENTION_PLANNED = 1903
    OBJECT_RETENTION = 1904
    STAMM_ID = 1000
    STAMM_TIME = 1001
    STAMM_LINKS = 1002
    REG_ID = 1120
    REG_STAID = 1121
    REG_PARID = 1122
    SDSTA_ID = 1130
    SDOBJ_ID = 1131
    SDOBJTYPE = 1132
    SDREG_ID = 1133
    SDDEL = 1134
    SDTIME = 1135
    SDREG_TYPE = 1136
    FOLDERID = 1181
    FOLDERTYPE = 1182
    REGISTERID = 1183
    REGISTERTYPE = 1184
    PARENTREGID = 1185
    PARENTREGTYPE = 1186
    MDDEL = 1140
    MDTIME = 1141
    MDMAP_ID = 1142
    MDSTA_ID = 1143
    MDOBJ_ID = 1144
    MDOBJTYPE = 1145
    MDMOD = 1146
    MDIN = 1147
    MDOUT = 1148
    MDCOUNT = 1149


class ImportActions(Enum):
    NONE = "NONE"
    INSERT = "INSERT"
    UPDATE = "UPDATE"
    ERROR = "ERROR"


class MainTypeId(Enum):
    FOLDER = 0
    REGISTER = 99
    DOC_GRAYSCALE = 1
    DOC_BW = 2
    DOC_COLOR = 3
    DOC_WINDOWS = 4
    DOC_MULTIMEDIA = 5
    DOC_MAIL = 6
    DOC_XML = 7
    DOC_CONTAINER = 8
    DOC_TYPELESS_USER = 200
    DOC_TYPELESS_WORKFLOW = 300
    PORTFOLIO = 203
    NOTE = 32767


class SortOrder(Enum):
    NONE = 0
    ASC = 1
    DESC = -1


class QueryOperators(Enum):
    LOWER_THAN = "<"
    LOWER_EQUAL = "<="
    EQUAL = "="
    NOT_EQUAL = "!="
    GREATER_THAN = ">"
    GREATER_EQUAL = ">="
    BETWEEN = "BETWEEN"
    NOT_BETWEEN = "NOT BETWEEN"
    IN = "IN"
    NOT_IN = "NOT_IN"


class SpecialValues(Enum):
    """Possible string query values for the `<SpecialValue>` tag"""

    COMPUTER_GUID = "#COMPUTER-GUID#"
    COMPUTER_NAME = "#COMPUTER-NAME#"
    COMPUTER_IP = "#COMPUTER-IP#"
    CREATOR = "#ANLEGER#"
    CREATION_DATE = "#ANLEGEDATUM#"
    ARCHIVIST = "#ARCHIVAR#"
    ARCHIVE_DATE = "#ARCHIVIERUNGSDATUM#"
    USER = "#BENUTZER#"
    OWNER = "#BESITZER#"
    DATE = "#DATUM#"


class ObjectSearchFlags(Enum):
    """Possible numeric query values for the system field `OBJEKT_SEARCHFLAGS`"""

    ARCHIVED = 1
    ARCHIVABLE = 2
    NOT_ARCHIVABLE = 4
    WITHOUT_PAGES = 8
    CHECKOUT_BY_ME = 16
    CHECKOUT_BY_OTHER = 32
    IN_REGISTER = 64
    NOT_IN_REGISTER = 128
    EXTERNAL = 256
    LINK = 512
    MULTI_LOCATION = 1024
    HAS_VARIANTS = 2048
    SIGNED_CURRENT_VERSION = 4096
    SIGNED_FORMER_VERSION = 8192


class FieldGroupOperators(Enum):
    OR = "OR"
    AND = "AND"


class StoreInCacheByIdConversion(Enum):
    """Possible numeric values for the `Convert` parameter of `std.StoreInCacheById`"""

    NONE = 0
    PDF = 1
    MULTIPAGE_TIFF = 8


class Jobs(Enum):
    """All jobs as of Server API manual 10.0"""

    ABN_ADD = "abn.Add"
    ABN_ADDREVISIT = "abn.AddRevisit"
    ABN_CHANGEREVISITUSER = "abn.ChangeRevisitUser"
    ABN_CHECKOSREVISIT = "abn.CheckOsrevisit"
    ABN_CONFIRMABOREAD = "abn.ConfirmAboRead"
    ABN_GETABOGRPLIST = "abn.GetAboGrpList"
    ABN_GETDOCLIST = "abn.GetDocList"
    ABN_GETGROUPLIST = "abn.GetGroupList"
    ABN_GETRECENTOBJECTS = "abn.GetRecentObjects"
    ABN_GETREQUESTLIST = "abn.GetRequestList"
    ABN_GETREVISITS = "abn.GetRevisits"
    ABN_GETSUBSCRIPTIONS = "abn.GetSubscriptions"
    ABN_GETUNREADABOCOUNT = "abn.GetUnreadAboCount"
    ABN_GETUNREADREVISITCOUNT = "abn.GetUnreadRevisitCount"
    ABN_GETUSERLIST = "abn.GetUserList"
    ABN_NOTIFYABONNEMENT = "abn.NotifyAbonnement"
    ABN_NOTIFYREQUESTABO = "abn.NotifyRequestAbo"
    ABN_REMOVE = "abn.Remove"
    ABN_REMOVEABOIDENT = "abn.RemoveAboIdent"
    ABN_REMOVEALLOBJABONOTIFYFROMUSER = "abn.RemoveAllObjAboNotifyFromUser"
    ABN_REMOVEOBJABONOTIFYFROMUSER = "abn.RemoveObjAboNotifyFromUser"
    ABN_REMOVEOBJREVISITNOTIFYFROMUSER = "abn.RemoveObjRevisitNotifyFromUser"
    ABN_RESETOSINFORMED = "abn.ResetOsInformed"
    ABN_SETOBJREVISITCLOSED = "abn.SetObjRevisitClosed"
    ABN_SETOBJREVISITOPEN = "abn.SetObjRevisitOpen"
    ABN_SETOSINFORMED = "abn.SetOsInformed"
    ABN_UPDATEREQABOGRP = "abn.UpdateReqAboGrp"
    ABN_UPDATEREVISIT = "abn.UpdateRevisit"
    ADM_CLEANUPCONFIG = "adm.CleanUpConfig"
    ADM_CLEANUPLOG = "adm.CleanUpLog"
    ADM_ENUMSERVERGROUPS = "adm.EnumServerGroups"
    ADM_ENUMSERVERS = "adm.EnumServers"
    ADM_GETSERVERFAMILYINFO = "adm.GetServerFamilyInfo"
    ADM_GETSERVERSACTIVITY = "adm.GetServersActivity"
    ADM_GETSYSTEMFILE = "adm.GetSystemFile"
    ADM_LOGDIRDELETEFILES = "adm.LogdirDeleteFiles"
    ADM_LOGDIRDOWNLOADFILES = "adm.LogdirDownloadFiles"
    ADM_LOGDIRGETINFO = "adm.LogdirGetInfo"
    ADM_STORESYSTEMFILE = "adm.StoreSystemFile"
    ADO_EXECUTESQL = "ado.ExecuteSQL"
    CNV_ADDANNOTATIONS = "cnv.AddAnnotations"
    CNV_CONVERTDOCUMENT = "cnv.ConvertDocument"
    CNV_CREATESLIDE = "cnv.CreateSlide"
    CNV_GETEXIFDATA = "cnv.GetExifData"
    CNV_GETICONS = "cnv.GetIcons"
    CNV_GETPAGECOUNT = "cnv.GetPageCount"
    CNV_GETPICTUREINFOS = "cnv.GetPictureInfos"
    CNV_GETRENDITION = "cnv.GetRendition"
    DMS_ADDPORTFOLIO = "DMS.AddPortfolio"
    DMS_ADDSTOREDQUERY = "DMS.AddStoredQuery"
    DMS_CHECKINDOCUMENT = "DMS.CheckInDocument"
    DMS_CHECKOUTDOCUMENT = "DMS.CheckOutDocument"
    DMS_CHECKPERMISSION = "DMS.CheckPermission"
    DMS_CHECKPERMISSIONS = "DMS.CheckPermissions"
    DMS_CONVERTQUERY = "DMS.ConvertQuery"
    DMS_COPYSD = "DMS.CopySD"
    DMS_CREATESD = "DMS.CreateSD"
    DMS_DELETESD = "DMS.DeleteSD"
    DMS_DELETEUSERDATA = "DMS.DeleteUserData"
    DMS_DELPORTFOLIO = "DMS.DelPortfolio"
    DMS_EXECUTESTOREDQUERY = "DMS.ExecuteStoredQuery"
    DMS_GETCHECKEDOUTDOCUMENTS = "DMS.GetCheckedOutDocuments"
    DMS_GETDELETEDOBJECTS = "DMS.GetDeletedObjects"
    DMS_GETFOREIGNOBJECTS = "DMS.GetForeignObjects"
    DMS_GETLINKEDOBJECTS = "DMS.GetLinkedObjects"
    DMS_GETOBJDEF = "DMS.GetObjDef"
    DMS_GETOBJECTDETAILS = "DMS.GetObjectDetails"
    DMS_GETOBJECTHISTORY = "DMS.GetObjectHistory"
    DMS_GETOBJECTSBYDIGEST = "DMS.GetObjectsByDigest"
    DMS_GETOBJECTTYPEBYID = "DMS.GetObjectTypeByID"
    DMS_GETOSMIMETYPES = "DMS.GetOsMimetypes"
    DMS_GETRESULTLIST = "DMS.GetResultList"
    DMS_GETSHADOWDATA = "DMS.GetShadowData"
    DMS_GETSTOREDQUERY = "DMS.GetStoredQuery"
    DMS_GETUSERDATA = "DMS.GetUserData"
    DMS_GETUSERDATAASSTRING = "DMS.GetUserDataAsString"
    DMS_GETUSERDATANAMES = "DMS.GetUserDataNames"
    DMS_GETUSERROLES = "DMS.GetUserRoles"
    DMS_GETUSERTRAYOBJECTS = "DMS.GetUserTrayObjects"
    DMS_GETWORKFLOWOBJECTS = "DMS.GetWorkflowObjects"
    DMS_GETXMLJOBOPTIONS = "DMS.GetXMLJobOptions"
    DMS_GETXMLSCHEMA = "DMS.GetXMLSchema"
    DMS_ISUSERDATA = "DMS.IsUserData"
    DMS_MODPORTFOLIO = "DMS.ModPortfolio"
    DMS_READSD = "DMS.ReadSD"
    DMS_REMOVEFROMPORTFOLIO = "DMS.RemoveFromportfolio"
    DMS_REMOVESTOREDQUERY = "DMS.RemoveStoredQuery"
    DMS_RESTOREINDEXDATAVERSION = "DMS.RestoreIndexdataVersion"
    DMS_RETRIEVEPORTFOLIOS = "DMS.RetrievePortfolios"
    DMS_SELECTDISTINCTFIELDVALUES = "DMS.SelectDistinctFieldValues"
    DMS_SETSD = "DMS.SetSD"
    DMS_SETUSERDATA = "DMS.SetUserData"
    DMS_SETUSERDATAASSTRING = "DMS.SetUserDataAsString"
    DMS_UNDOCHECKOUTDOCUMENT = "DMS.UndoCheckOutDocument"
    DMS_UPDATESTOREDQUERY = "DMS.UpdateStoredQuery"
    DMS_XMLCOPY = "DMS.XMLCopy"
    DMS_XMLDELETE = "DMS.XMLDelete"
    DMS_XMLIMPORT = "DMS.XMLImport"
    DMS_XMLINSERT = "DMS.XMLInsert"
    DMS_XMLMOVE = "DMS.XMLMove"
    DMS_XMLUNKNOWNTOKNOWN = "DMS.XMLUnknownToKnown"
    DMS_XMLUPDATE = "DMS.XMLUpdate"
    KRN_APPSEVENTSENUM = "krn.AppsEventsEnum"
    KRN_APPSEVENTSSUBSCRIBE = "krn.AppsEventsSubscribe"
    KRN_BATCHADD = "krn.BatchAdd"
    KRN_BATCHCHANGE = "krn.BatchChange"
    KRN_BATCHENUM = "krn.BatchEnum"
    KRN_BATCHGETSTATISTIC = "krn.BatchGetStatistic"
    KRN_BATCHREMOVE = "krn.BatchRemove"
    KRN_CHECKCRASHEDSERVERS = "krn.CheckCrashedServers"
    KRN_CHECKDISKSPACE = "krn.CheckDiskSpace"
    KRN_CHECKSERVERCONNECTION = "krn.CheckServerConnection"
    KRN_CHECKUSERACCOUNT = "krn.CheckUserAccount"
    KRN_EMPTYJOB = "Krn.EmptyJob"
    KRN_ENUMJOBS = "krn.EnumJobs"
    KRN_ENUMMODULES = "krn.EnumModules"
    KRN_ENUMNAMESPACES = "krn.EnumNameSpaces"
    KRN_GETCOUNTER = "krn.GetCounter"
    KRN_GETFILEVERSIONLIST = "krn.GetFileVersionList"
    KRN_GETNAMESPACEPARAMS = "krn.GetNameSpaceParams"
    KRN_GETNEXTINDEX = "krn.GetNextIndex"
    KRN_GETSERVERINFO = "krn.GetServerInfo"
    KRN_GETSERVERINFOEX = "krn.GetServerInfoEx"
    KRN_JOBTHREADBREAK = "krn.JobThreadBreak"
    KRN_JOBTHREADGETINFO = "krn.JobThreadGetInfo"
    KRN_LOADEXECUTOR = "krn.LoadExecutor"
    KRN_LOGCONFIGGET = "krn.LogConfigGet"
    KRN_LOGCONFIGSET = "krn.LogConfigSet"
    KRN_MAKEBEATPING = "krn.MakeBeatPing"
    KRN_NAMESPACEENUM = "krn.NameSpaceEnum"
    KRN_NAMESPACEGETINFO = "krn.NameSpaceGetInfo"
    KRN_NAMESPACEGETJOBSINFO = "krn.NameSpaceGetJobsInfo"
    KRN_PROCESSGETINFORMATION = "krn.ProcessGetInformation"
    KRN_QUEUEENUM = "krn.QueueEnum"
    KRN_QUEUEGETPARAMS = "krn.QueueGetParams"
    KRN_QUEUEGETSTATISTIC = "krn.QueueGetStatistic"
    KRN_REBACKUP = "krn.REBackup"
    KRN_REFILLSERVERLIST = "krn.RefillServerList"
    KRN_REGETCURRENTSCHEMA = "krn.REGetCurrentSchema"
    KRN_REGETREGVALUE = "krn.REGetRegValue"
    KRN_RELOAD = "krn.RELoad"
    KRN_RELOADEXECUTOR = "krn.ReloadExecutor"
    KRN_RESAVE = "krn.RESave"
    KRN_RESETREGVALUE = "krn.RESetRegValue"
    KRN_RUNSCRIPT = "krn.RunScript"
    KRN_SENDADMINMAIL = "krn.SendAdminMail"
    KRN_SENDMAIL = "krn.SendMail"
    KRN_SENDMESSAGETOCLIENTS = "krn.SendMessageToClients"
    KRN_SESSIONATTACH = "krn.SessionAttach"
    KRN_SESSIONDELETELOST = "krn.SessionDeleteLost"
    KRN_SESSIONDROP = "krn.SessionDrop"
    KRN_SESSIONDROPDB = "krn.SessionDropDB"
    KRN_SESSIONENUM = "krn.SessionEnum"
    KRN_SESSIONENUMDB = "krn.SessionEnumDB"
    KRN_SESSIONENUMRESOURCESDB = "krn.SessionEnumResourcesDB"
    KRN_SESSIONGETINFO = "krn.SessionGetInfo"
    KRN_SESSIONLOGIN = "krn.SessionLogin"
    KRN_SESSIONLOGOUT = "krn.SessionLogout"
    KRN_SESSIONPROPERTIESENUM = "krn.SessionPropertiesEnum"
    KRN_SESSIONPROPERTIESGET = "krn.SessionPropertiesGet"
    KRN_SESSIONPROPERTIESSET = "krn.SessionPropertiesSet"
    KRN_SHUTDOWN = "krn.ShutDown"
    KRN_UNLOADEXECUTOR = "krn.UnloadExecutor"
    KRN_USERSESSIONCREATE = "krn.UserSessionCreate"
    KRN_USERSESSIONDELETE = "krn.UserSessionDelete"
    LIC_CHECKLICENSE = "lic.CheckLicense"
    LIC_LICCOPYDEFAULT = "lic.LicCopyDefault"
    LIC_LICFREERESOURCE = "lic.LicFreeResource"
    LIC_LICGETGLOBALINFO = "lic.LicGetGlobalInfo"
    LIC_LICGETGLOBALINFOEX = "lic.LicGetGlobalInfoEx"
    LIC_LICGETMODULEINFO = "lic.LicGetModuleInfo"
    LIC_LICGETQUEUESTATUS = "lic.LicGetQueueStatus"
    LIC_LICLOGIN = "lic.LicLogin"
    LIC_LICLOGINEX = "lic.LicLoginEx"
    LIC_LICLOGOUT = "lic.LicLogout"
    LIC_LICLOGOUTEX = "lic.LicLogoutEx"
    LIC_LICRESETDATA = "lic.LicResetData"
    MED_CREATELABORATORYREPORT = "med.CreateLaboratoryReport"
    MED_GETMEDICALRECORD = "med.GetMedicalRecord"
    MED_GETSYSTEMOID = "med.GetSystemOID"
    MED_LOINCOBSERVATIONS = "med.LoincObservations"
    MED_LOINCRESULTS = "med.LoincResults"
    MED_LOINCUNITS = "med.LoincUnits"
    MED_LOINCVIEWSETS = "med.LoincViewSets"
    MED_NOTIFYMEDICALRECORD = "med.NotifyMedicalRecord"
    MED_OBSERVATIONINSERT = "med.ObservationInsert"
    MED_OBSERVATIONREQUESTHISTORY = "med.ObservationRequestHistory"
    MED_OBSERVATIONRESULTHISTORY = "med.ObservationResultHistory"
    MED_OBSERVATIONVALUES = "med.ObservationValues"
    MED_PATIENTDATA = "med.PatientData"
    MED_SAVEMEDICALRECORD = "med.SaveMedicalRecord"
    MED_UPDATEPATIENTID = "med.UpdatePatientId"
    MED_UPDATEVISITID = "med.UpdateVisitId"
    MNG_ADDUSERGROUPASC = "mng.AddUserGroupAsc"
    MNG_CREATEGROUP = "mng.CreateGroup"
    MNG_CREATEUSER = "mng.CreateUser"
    MNG_DELETEGROUP = "mng.DeleteGroup"
    MNG_DELETEUSER = "mng.DeleteUser"
    MNG_EMPTYGROUP = "mng.EmptyGroup"
    MNG_GETGROUPATTRIBUTES = "mng.GetGroupAttributes"
    MNG_GETGROUPLIST = "mng.GetGroupList"
    MNG_GETGROUPMEMBERS = "mng.GetGroupMembers"
    MNG_GETUSERATTRIBUTES = "mng.GetUserAttributes"
    MNG_GETUSERGROUPS = "mng.GetUserGroups"
    MNG_GETUSERLIST = "mng.GetUserList"
    MNG_GETUSERPROFILE = "mng.GetUserProfile"
    MNG_REMOVEUSERGROUPASC = "mng.RemoveUserGroupAsc"
    MNG_SETGROUPATTRIBUTES = "mng.SetGroupAttributes"
    MNG_SETUSERATTRIBUTES = "mng.SetUserAttributes"
    MNG_STOREUSERPROFILE = "mng.StoreUserProfile"
    OCR_DODOCOCR = "ocr.DoDocOCR"
    OCR_DOOCR = "ocr.DoOCR"
    STD_GETTEMPLATES = "std.GetTemplates"
    STD_ADJUSTRETENTIONS = "std.AdjustRetentions"
    STD_CALCDOCUMENTDIGEST = "std.CalcDocumentDigest"
    STD_CHECKSOURCE = "std.CheckSource"
    STD_CLEANUPCACHE = "std.CleanUpCache"
    STD_CLEARFROMCACHE = "std.ClearFromCache"
    STD_CONFIGVARC = "std.ConfigVarc"
    STD_DELETEDOCUMENT = "std.DeleteDocument"
    STD_DELETEDOCUMENTVERSION = "std.DeleteDocumentVersion"
    STD_DELETEOBJECT = "std.DeleteObject"
    STD_DELETEREMARK = "std.DeleteRemark"
    STD_DISKSPACE = "std.DiskSpace"
    STD_DOARCHIVE = "std.DoArchive"
    STD_DOPREFETCH = "std.DoPrefetch"
    STD_FILETRANSFER = "std.FileTransfer"
    STD_FINDDOCUMENTDIGEST = "std.FindDocumentDigest"
    STD_GETDOCSTATISTICS = "std.GetDocStatistics"
    STD_GETDOCSTREAM = "std.GetDocStream"
    STD_GETDOCUMENTDIGEST = "std.GetDocumentDigest"
    STD_GETDOCUMENTPAGE = "std.GetDocumentPage"
    STD_GETDOCUMENTSLIDE = "std.GetDocumentSlide"
    STD_GETDOCUMENTSTREAM = "std.GetDocumentStream"
    STD_GETDOCVARIANT = "std.GetDocVariant"
    STD_GETDOCVERSION = "std.GetDocVersion"
    STD_GETOBJECTINFO = "std.GetObjectInfo"
    STD_GETREMARK = "std.GetRemark"
    STD_GETSIGNEDDOCUMENT = "std.GetSignedDocument"
    STD_INDEXDATACHANGED = "std.IndexDataChanged"
    STD_MERGEDOCUMENTS = "std.MergeDocuments"
    STD_MERGEFOLDER = "std.MergeFolder"
    STD_MOVETOCACHE = "std.MoveToCache"
    STD_OBJECTTRANSFER = "std.ObjectTransfer"
    STD_PACKDIRECTORY = "std.PackDirectory"
    STD_RESTOREDOCVERSION = "std.RestoreDocVersion"
    STD_RESTOREOBJECT = "std.RestoreObject"
    STD_SETACTIVEVARIANT = "std.SetActiveVariant"
    STD_SETHISTORY = "std.SetHistory"
    STD_SETPLANNEDRETENTION = "std.SetPlannedRetention"
    STD_STOREINCACHE = "std.StoreInCache"
    STD_STOREINCACHEBYID = "std.StoreInCacheByID"
    STD_STOREINCACHEDIRECT = "std.StoreInCacheDirect"
    STD_STOREINWORK = "std.StoreInWork"
    STD_STOREREMARK = "std.StoreRemark"
    STD_STORESIGNEDDOCUMENT = "std.StoreSignedDocument"
    STD_TRANSFORMINDEXDATA = "std.TransformIndexData"
    STD_UNDOARCHIVE = "std.UndoArchive"
    STD_UNKNOWN2KNOWN = "std.Unknown2Known"
    STD_ZIPDOCUMENT = "std.ZipDocument"
    VTX_CLEANUPCLIENT = "vtx.CleanupClient"
    VTX_CLOSEQUERY = "vtx.CloseQuery"
    VTX_GETDOCUMENT = "vtx.GetDocument"
    VTX_GETENGINENAME = "vtx.GetEngineName"
    VTX_GETMAXHITS = "vtx.GetMaxHits"
    VTX_GETSIMILARDMSOBJECTS = "vtx.GetSimilarDMSObjects"
    VTX_ISONTOLOGYSEARCHENABLED = "vtx.IsOntologySearchEnabled"
    VTX_ISSEARCHFORSIMILARDMSOBJECTSENABLED = "vtx.IsSearchForSimilarDMSObjectsEnabled"
    VTX_OPENOBJECTQUERY = "vtx.OpenObjectQuery"
    VTX_OPENWORDLISTQUERY = "vtx.OpenWordListQuery"
    WFM_ADHOCCONFIGTEMPLATE = "wfm.AdhocConfigTemplate"
    WFM_ADHOCGETTEMPLATELIST = "wfm.AdhocGetTemplateList"
    WFM_ADMINDELETEPROCESSES = "wfm.AdminDeleteProcesses"
    WFM_ADMINDELETESTATISTICREPORTS = "wfm.AdminDeleteStatisticReports"
    WFM_ADMINGETACTIVITYVARIABLES = "wfm.AdminGetActivityVariables"
    WFM_ADMINGETLOCKINFO = "wfm.AdminGetLockInfo"
    WFM_ADMINGETPROCESSACTIVITIES = "wfm.AdminGetProcessActivities"
    WFM_ADMINGETPROCESSLIST = "wfm.AdminGetProcessList"
    WFM_ADMINGETPROCESSLISTBYROLE = "wfm.AdminGetProcessListByRole"
    WFM_ADMINGETPROCESSLISTBYUSER = "wfm.AdminGetProcessListByUser"
    WFM_ADMINGETPROCESSLOCKS = "wfm.AdminGetProcessLocks"
    WFM_ADMINGETPROCESSREPORT = "wfm.AdminGetProcessReport"
    WFM_ADMINGETROLEPROCESSES = "wfm.AdminGetRoleProcesses"
    WFM_ADMINGETSTATISTICREPORTCONFIGS = "wfm.AdminGetStatisticReportConfigs"
    WFM_ADMINGETSTATISTICREPORTDATA = "wfm.AdminGetStatisticReportData"
    WFM_ADMINGETSTATISTICREPORTS = "wfm.AdminGetStatisticReports"
    WFM_ADMINGETUSERPROCESSES = "wfm.AdminGetUserProcesses"
    WFM_ADMINGETWORKERQUEUE = "wfm.AdminGetWorkerqueue"
    WFM_ADMINGETWORKFLOWLIST = "wfm.AdminGetWorkflowList"
    WFM_ADMINRELEASELOCK = "wfm.AdminReleaseLock"
    WFM_ADMINREQUESTSTATISTICREPORT = "wfm.AdminRequestStatisticReport"
    WFM_ADMINRESUMEACTIVITY = "wfm.AdminResumeActivity"
    WFM_ADMINRESUMEPROCESS = "wfm.AdminResumeProcess"
    WFM_ADMINROLLBACKPROCESS = "wfm.AdminRollbackProcess"
    WFM_ADMINSAVEACTIVITYVARIABLES = "wfm.AdminSaveActivityVariables"
    WFM_ADMINSAVEREPORTCONFIG = "wfm.AdminSaveReportConfig"
    WFM_ADMINSUSPENDACTIVITY = "wfm.AdminSuspendActivity"
    WFM_ADMINSUSPENDPROCESS = "wfm.AdminSuspendProcess"
    WFM_ADMINTERMINATEACTIVITY = "wfm.AdminTerminateActivity"
    WFM_ADMINTERMINATEPROCESS = "wfm.AdminTerminateProcess"
    WFM_CANCELWORKITEM = "wfm.CancelWorkItem"
    WFM_CHANGEWORKFLOWSTATE = "wfm.ChangeWorkflowState"
    WFM_CHECKJOB = "wfm.CheckJob"
    WFM_COMPLETEWORKITEM = "wfm.CompleteWorkItem"
    WFM_CONFIGUSERABSENCE = "wfm.ConfigUserAbsence"
    WFM_CONVERTEXPORTFILE = "wfm.ConvertExportFile"
    WFM_COPYWORKFLOW = "wfm.CopyWorkflow"
    WFM_CREATEPROCESSINSTANCE = "wfm.CreateProcessInstance"
    WFM_DBCOMMANDS = "wfm.DBCommands"
    WFM_DELETEEVENT = "wfm.DeleteEvent"
    WFM_DELETEMASKS = "wfm.DeleteMasks"
    WFM_DELETEORGANISATION = "wfm.DeleteOrganisation"
    WFM_DELETESCRIPT = "wfm.DeleteScript"
    WFM_DELETESYSCLIENTTYPES = "wfm.DeleteSysClienttypes"
    WFM_DELETEWORKFLOW = "wfm.DeleteWorkflow"
    WFM_EXPORT = "wfm.Export"
    WFM_GETABSENTUSERS = "wfm.GetAbsentUsers"
    WFM_GETACTIVITYPERFORMERS = "wfm.GetActivityPerformers"
    WFM_GETEVENTS = "wfm.GetEvents"
    WFM_GETEVENTTYPES = "wfm.GetEventTypes"
    WFM_GETGLOBALSCRIPTS = "wfm.GetGlobalScripts"
    WFM_GETHISTACTIVITIESBYPROCESS = "wfm.GetHistActivitiesByProcess"
    WFM_GETHISTENTRIES = "wfm.GetHistEntries"
    WFM_GETHISTPROCESSLIST = "wfm.GetHistProcessList"
    WFM_GETHISTTIMERENTRIES = "wfm.GetHistTimerEntries"
    WFM_GETHISTTIMERSBYPROCESS = "wfm.GetHistTimersByProcess"
    WFM_GETHISTVARIABLESBYHISTENTRY = "wfm.GetHistVariablesByHistEntry"
    WFM_GETHISTWORKFLOWLIST = "wfm.GetHistWorkflowList"
    WFM_GETHISTWORKITEMRELACTIVITIESBYPROCESS = "wfm.GetHistWorkItemRelActivitiesByProcess"
    WFM_GETHISTWORKITEMRELENTRIESBYACTIVITY = "wfm.GetHistWorkItemRelEntriesByActivity"
    WFM_GETHISTWORKITEMRELENTRIESBYUSER = "wfm.GetHistWorkItemRelEntriesByUser"
    WFM_GETHISTWORKITEMRELUSERSBYPROCESS = "wfm.GetHistWorkItemRelUsersByProcess"
    WFM_GETORGANISATIONCLASSES = "wfm.GetOrganisationClasses"
    WFM_GETORGANISATIONOBJECTS = "wfm.GetOrganisationObjects"
    WFM_GETORGANISATIONS = "wfm.GetOrganisations"
    WFM_GETPROCESSFILE = "wfm.GetProcessFile"
    WFM_GETPROCESSLIST = "wfm.GetProcessList"
    WFM_GETPROCESSLISTBYOBJECT = "wfm.GetProcessListByObject"
    WFM_GETPROCESSPROTOCOL = "wfm.GetProcessProtocol"
    WFM_GETPROCESSRESPONSIBLES = "wfm.GetProcessResponsibles"
    WFM_GETPROJECTLIST = "wfm.GetProjectList"
    WFM_GETRUNNINGACTIVITIES = "wfm.GetRunningActivities"
    WFM_GETSUBSTITUTES = "wfm.GetSubstitutes"
    WFM_GETSYSCLIENTTYPES = "wfm.GetSysClienttypes"
    WFM_GETUSERSUBSTITUTES = "wfm.GetUserSubstitutes"
    WFM_GETVERSIONINFO = "wfm.GetVersionInfo"
    WFM_GETWFMINFO = "wfm.GetWFMInfo"
    WFM_GETWORKFLOW = "wfm.GetWorkflow"
    WFM_GETWORKFLOWDATA = "wfm.GetWorkflowData"
    WFM_GETWORKFLOWINFO = "wfm.GetWorkflowInfo"
    WFM_GETWORKFLOWLIST = "wfm.GetWorkflowList"
    WFM_GETWORKFLOWLISTBYFAMILY = "wfm.GetWorkflowListByFamily"
    WFM_GETWORKITEM = "wfm.GetWorkItem"
    WFM_GETWORKITEMLIST = "wfm.GetWorkItemList"
    WFM_GETWORKITEMPARAMS = "wfm.GetWorkItemParams"
    WFM_IMPORT = "wfm.Import"
    WFM_INSERTSYSCLIENTTYPES = "wfm.InsertSysClienttypes"
    WFM_LOADMASKS = "wfm.LoadMasks"
    WFM_LOADSCRIPT = "wfm.LoadScript"
    WFM_SAVEEVENT = "wfm.SaveEvent"
    WFM_SAVEMASKS = "wfm.SaveMasks"
    WFM_SAVEORGANISATION = "wfm.SaveOrganisation"
    WFM_SAVESCRIPT = "wfm.SaveScript"
    WFM_SERVERNOTIFYCLIENTS = "wfm.ServerNotifyClients"
    WFM_SERVERUPDATEWORKFLOWMODELS = "wfm.ServerUpdateWorkflowModels"
    WFM_SERVERUSERABSENT = "wfm.ServerUserAbsent"
    WFM_SETACTIVEORGANISATION = "wfm.SetActiveOrganisation"
    WFM_SETACTIVITYPERFORMERS = "wfm.SetActivityPerformers"
    WFM_SETEVENTSCRIPTRELATION = "wfm.SetEventScriptRelation"
    WFM_SETPROCESSRESPONSIBLES = "wfm.SetProcessResponsibles"
    WFM_SETSUBSTITUTES = "wfm.SetSubstitutes"
    WFM_STARTPROCESS = "wfm.StartProcess"
    WFM_STARTWORKITEM = "wfm.StartWorkItem"
    WFM_STOREWORKFLOW = "wfm.StoreWorkflow"
    WFM_VALIDATEWORKFLOW = "wfm.ValidateWorkflow"
    WFM_WORKERJOB = "wfm.WorkerJob"
    WFM_WORKITEMNOTI = "wfm.WorkItemNoti"
