# Photon: Machine Learning Framework
A machine learning framework that extends the functionality of other frameworks such as TensorFlow & Keras. Photon ML is built to apply neural network and ensemble modeling techniques for deep learning financial algorithms. The framework supports the entire lifecycle of a machine learning project including data preparation, model development, training, monitoring, evaluation and deployment.

**Key Features of Photon ML:**

- Custom object-oriented API with built-in subclassing of Keras and TensorFlow APIs.
- Built-in custom modules such as Models, Layers, Optimizers and Loss Functions.
- Highly customizable interface to extend built-in modules for specific algorithms/networks.
- Detailed logging and analysis of model parameters to increase interpretability and optimization.
- Works natively with TensorFlow distributed strategies.
- Real-time data preprocessing; dataset splitting, normalization, scaling, aggregation & resampling.
- Custom batching, padding and masking of data.
- Designed to be model/algorithm agnostic and to work natively with container services.
- Natively shares input & output between multiple networks to streamline deep ensemble learning.
- Interface for saving, serializing and loading entire networks including learned & hyper parameters.
- Custom dynamic learning rate scheduling.

---
**Photon ML Examples:** https://github.com/sequenzia/photon_examples