# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/utils.ipynb (unless otherwise specified).

__all__ = ['moving_avg']

# Cell
from typing import List

# Cell
def moving_avg(inputs: list, w: int = 10) -> List[float]:
    """Computes the moving average of a list over a sliding window."""
    cumsum, moving_avgs = [0], []
    for i, x in enumerate(inputs, 1):
        cumsum.append(cumsum[i-1] + x)
        if i >= w:
            moving_avg = (cumsum[i] - cumsum[i-w]) / w
            moving_avgs.append(moving_avg)
    return moving_avgs