# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/losses.ipynb (unless otherwise specified).

__all__ = ['FlatLoss', 'FlatCrossEntropyLoss', 'FlatBCELoss', 'FlatMSELoss']

# Cell
import torch
import torch.nn as nn

from functools import update_wrapper
from torch.nn.modules.loss import _Loss

# Cell
class FlatLoss():
    """Same as whatever `func` is, but with flattened input and target."""
    def __init__(self, func: _Loss, axis: int = -1, to_float: bool = False,
                 is_2d: bool = False, **kwargs):
        self.func = func(**kwargs)
        self.axis = axis
        self.to_float = to_float
        self.is_2d = is_2d

        update_wrapper(self, self.func)

    def __repr__(self):
        return f'FlatLoss of {self.func}'

    @property
    def reduction(self) -> str:
        assert hasattr(self.func, 'reduction'), f'{self.func} does not have "reduction" attribute'
        return self.func.reduction

    @reduction.setter
    def reduction(self, reduction: str):
        self.func.reduction = reduction

    @property
    def weight(self) -> torch.tensor:
        assert hasattr(self.func, 'weight'), f'{self.func} does not have "weight" attribute'
        return self.func.weight

    @weight.setter
    def weight(self, weight: torch.tensor):
        self.func.weight = weight

    def __call__(self, prediction: torch.tensor, target: torch.tensor, **kwargs) -> torch.tensor:
        prediction = prediction.transpose(self.axis, -1).contiguous()
        target = target.transpose(self.axis, -1).contiguous()

        if self.to_float:
            target = target.float()

        prediction = prediction.view(-1, prediction.shape[-1]) if self.is_2d else prediction.view(-1)
        return self.func.__call__(prediction, target.view(-1), **kwargs)

# Cell
def FlatCrossEntropyLoss(axis: int = -1, to_float: bool = True, is_2d: bool = False, **kwargs):
    """Same as `nn.CrossEntropyLoss`, but with flattened input and target."""
    return FlatLoss(nn.CrossEntropyLoss, axis=axis, to_float=to_float, is_2d=is_2d, **kwargs)

# Cell
def FlatBCELoss(axis: int = -1, to_float: bool = True, is_2d: bool = False, **kwargs):
    """Same as `nn.BCELoss`, but with flattened input and target."""
    return FlatLoss(nn.BCELoss, axis=axis, to_float=to_float, is_2d=is_2d, **kwargs)

# Cell
def FlatMSELoss(axis: int = -1, to_float: bool = True, is_2d: bool = False, **kwargs):
    """Same as `nn.MSELoss`, but with flattened input and target."""
    return FlatLoss(nn.MSELoss, axis=axis, to_float=to_float, is_2d=is_2d, **kwargs)