<div align="center">
  <img src="images/icevision-logo-slogan.png" alt="logo" width="535px" style="display: block; margin-left: auto; margin-right: auto"/>
  <h2><b>An Agnostic Object Detection Framework</b></h2>
</div>

* * * * *

    
[![tests](https://github.com/airctic/icevision/workflows/tests/badge.svg?event=push)](https://github.com/airctic/icevision/actions?query=workflow%3Atests)
[![docs](https://github.com/airctic/icevision/workflows/docs/badge.svg)](https://airctic.com)
[![codecov](https://codecov.io/gh/airctic/icevision/branch/master/graph/badge.svg)](https://codecov.io/gh/airctic/icevision)
[![PyPI version](https://badge.fury.io/py/icevision.svg)](https://badge.fury.io/py/icevision)
[![Downloads](https://pepy.tech/badge/icevision)](https://pepy.tech/project/icevision)

[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![license](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://github.com/airctic/icevision/blob/master/LICENSE)
[![Discord](https://img.shields.io/discord/735877944085446747?label=Discord&logo=Discord)](https://discord.gg/2jqrwrQ)

</div>


* * * * *

IceVision is the first agnostic computer vision framework to offer a curated collection with hundreds of high-quality pre-trained models from torchvision, MMLabs, and soon Pytorch Image Models. It orchestrates the end-to-end deep learning workflow allowing to train networks with easy-to-use robust high-performance libraries such as Pytorch-Lightning and Fastai

**IceVision Unique Features:**

- Data curation/cleaning with auto-fix

- Access to an exploratory data analysis dashboard

- Pluggable transforms for better model generalization 

- Access to hundreds of neural net models

- Access to multiple training loop libraries

- Multi-task training to efficiently combine object detection, segmentation, and classification models 

<!-- Not included in docs - start -->

## Installation

```bash
pip install icevision[all]
```

For more installation options, check our [docs](https://airctic.com/0.7.0/install/).

**Important:** We currently only support Linux/MacOS.
<!-- Not included in docs - end -->

## Quick Example: How to train the **Fridge Objects Dataset**
<a href="https://colab.research.google.com/github/airctic/icevision/blob/master/notebooks/getting_started_object_detection.ipynb" target="_parent"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>
![image](images/icevision-readme.png)

![image](images/icevision-end-to-end-training.gif)

## Happy Learning!
If you need any assistance, feel free to:

[Join our Forum](https://discord.gg/JDBeZYK)
