import os
import tempfile


def get_epias_ssl_certificate():
    """
    EPIAS SSL certificate valid from May 2023
    """
    cert = """-----BEGIN CERTIFICATE-----
MIIH6DCCBtCgAwIBAgIRAMa7grh4xKa2abBClhrDHvYwDQYJKoZIhvcNAQELBQAw
gZYxCzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAO
BgNVBAcTB1NhbGZvcmQxGjAYBgNVBAoTEUNPTU9ETyBDQSBMaW1pdGVkMTwwOgYD
VQQDEzNDT01PRE8gUlNBIE9yZ2FuaXphdGlvbiBWYWxpZGF0aW9uIFNlY3VyZSBT
ZXJ2ZXIgQ0EwHhcNMjMwNTA0MDAwMDAwWhcNMjQwNjAzMjM1OTU5WjBiMQswCQYD
VQQGEwJUUjESMBAGA1UECAwJxLBzdGFuYnVsMSYwJAYDVQQKEx1FbmVyamkgUGl5
YXNhbGFyaSBJc2xldG1lIEEuUzEXMBUGA1UEAwwOKi5lcGlhcy5jb20udHIwggIi
MA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDISf40VTZddHOhjueYvrdYC33r
MtCjcW8Ogu55fwplUejiTClOpikA85E2HGAkroR5g27g8IN/QdApsssSU+xkiDdK
MC4wR36gJFxU27Y3ed7O/kJ9+w9mkzjF8xFLjWjL0bP4agT5wW3gKnxKyy/CcDZv
s6gHP3Jgi8/rsAovkgpq00nDMyvp7GdHToDlUaAoLdknjy+fCr4kTFh+WqOtO/ln
kZ9UNo34oIgmErjkSc8h8tIOBlURI06ccr914+uCigmK9mg6VlavxqSrRcQW2hdG
dO9oAj5q7NTq9AwxQVFiIxYiw78DUPV+6jjGpLNsPh8qbTxyUnD2nBkg8GSIxfkK
JyDnTkAdB6RD6JGtIoqw6D726hSB3uaujdfftbTfeY9K5GO6jANESwk8pGGEvFh/
sH8lN5cuC8afXuVWAkVlsok77aEBdEt9gg+O91bIriSOnl3EDNVgw0+rFBTIbrQt
5LX48OH3NJfVyF7UyQxBi7FnTUHGXulGaVqzXHyorBaRwvKhaREpnj7+P+ikWjzB
1BXWKe1hPfqQ1cJPRPJkrEUEXk9Y34OBn9fMScMFDu9P2pBdOD+h73EugvhEkYTm
ya6xWh8XJ7Ef7vc4afvAbEe4O3tTljGIzmryq1+v+lalxVXHys+/WsXICK4g5HRo
ZpI2DnmUBBB01MYwxQIDAQABo4IDYjCCA14wHwYDVR0jBBgwFoAUmvMr2s+tT7Yv
uypISCoStxtCwSQwHQYDVR0OBBYEFJNbDlFpSniLY5v48SOsE5U+YAnuMA4GA1Ud
DwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggr
BgEFBQcDAjBKBgNVHSAEQzBBMDUGDCsGAQQBsjEBAgEDBDAlMCMGCCsGAQUFBwIB
FhdodHRwczovL3NlY3RpZ28uY29tL0NQUzAIBgZngQwBAgIwWgYDVR0fBFMwUTBP
oE2gS4ZJaHR0cDovL2NybC5jb21vZG9jYS5jb20vQ09NT0RPUlNBT3JnYW5pemF0
aW9uVmFsaWRhdGlvblNlY3VyZVNlcnZlckNBLmNybDCBiwYIKwYBBQUHAQEEfzB9
MFUGCCsGAQUFBzAChklodHRwOi8vY3J0LmNvbW9kb2NhLmNvbS9DT01PRE9SU0FP
cmdhbml6YXRpb25WYWxpZGF0aW9uU2VjdXJlU2VydmVyQ0EuY3J0MCQGCCsGAQUF
BzABhhhodHRwOi8vb2NzcC5jb21vZG9jYS5jb20wJwYDVR0RBCAwHoIOKi5lcGlh
cy5jb20udHKCDGVwaWFzLmNvbS50cjCCAX4GCisGAQQB1nkCBAIEggFuBIIBagFo
AHUAdv+IPwq2+5VRwmHM9Ye6NLSkzbsp3GhCCp/mZ0xaOnQAAAGH5sripQAABAMA
RjBEAh9QeDEX3SrbJ4rChJc6WVh5yVJmnzOoSIrr7U3MB0ofAiEAhDfl8VrKat2w
vdTJ5AwBGDz77WscMzKvH9LZhTVxntQAdwDatr9rP7W2Ip+bwrtca+hwkXFsu1GE
hTS9pD0wSNf7qwAAAYfmyuMHAAAEAwBIMEYCIQCm6FCcuKo9CK3X0PVjvWQIR9l7
WrAo+9XtCo12AYsg4AIhALYCi5K6iq9beiiXeDREg5TqKwWlISi3zDXI9zK+HZFl
AHYA7s3QZNXbGs7FXLedtM0TojKHRny87N7DUUhZRnEftZsAAAGH5sri1AAABAMA
RzBFAiBFaUB9hbvrU1rDWq/iZs6ItUok+VdAPlETDVDqfL94JwIhAO45Wa6sNxD7
Phn1xX91Sw84Rv1PgZ/F+GnmjRvOnJU6MA0GCSqGSIb3DQEBCwUAA4IBAQAzzJhO
my5fgL1Lfy+DSH7grc0TBe8EW0a72ib9DCog/EnAdInciv9JxkwJTHmP4y09N4EZ
B+DaCPI+b3dhbPNs1qkeR67w2WJFGBpgl0JljcRJ6RHGckkGZ+w7qXU95qlyboLi
uPErDokvDZTEgKFgdZztHWOmtWUyTir47+hrs/3K2J87Rk5eVUvX7oYx65VqduTL
3/b72wFvELycb5XDo3Qk9osIF7rpQi1nibTf5ZNpPI+pVTTeTrlCxM7FKp+byo+U
31Sidc9W0nFRY36j202tCSL/EUhal3dBSymW2VTCT4Csr61pgMwUTW4U4I2DIPSo
iheHNvQpLsivK96Q
-----END CERTIFICATE-----
"""

    return cert


def get_epias_ssl_certificate_file():
    tmp = tempfile.NamedTemporaryFile(suffix=".pem")
    tmp.write(get_epias_ssl_certificate().strip().encode())
    tmp.seek(0)
    # tmp.close()
    return tmp
