# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ogscm', 'ogscm.building_blocks']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'hpccm>=20.9.0,<21.0.0',
 'packaging>=20.4,<21.0',
 'requests>=2.24.0,<3.0.0']

entry_points = \
{'console_scripts': ['ogscm = ogscm.cli:main']}

setup_kwargs = {
    'name': 'ogscm',
    'version': '1.6.1',
    'description': 'OGS Container Maker',
    'long_description': '# OGS Container Maker\n\n## General usage\n\n### Installation\n\n```bash\nvirtualenv ~/.venv/ogs-container-maker\nsource ~/.venv/ogs-container-maker/bin/activate\npip install ogscm\n```\n\n### Generate container definition\n\n```bash\n$ ogscm\nCreating 1 image definition(s)...\nCreated definition _out/docker/ubuntu_17.10/ogs-4c7de6a4/serial/conan/cmake-d41d8cd9/Dockerfile\n\n# With user options\n$ ogscm --format singularity --ompi 2.1.3 --cmake_args \' -DOGS_BUILD_PROCESSES=GroundwaterFlow\'\nCreating 1 image definition(s)...\nCreated definition _out/singularity/ubuntu_17.10/ogs-4c7de6a4/openmpi-2.1.3/conan/cmake-fde09bf7/Singularity.de\n```\n\n### Build image\n\nAdd the `--build`-flag.\n\nConvert Docker image to Singularity image:\n\nAdd the `--convert`-flag (requires Singularity 3.x).\n\n### Run\n\n```bash\ndocker run --it --rm ogs-ompi-2.1.3\n# in container:\nogs --version\n```\n\n```bash\nsingularity shell ogs-ompi-2.1.3.sif\n# in container:\nogs --version\n# OR directly run from host\nsingularity exec ogs-ompi-2.1.3.sif ogs local/path/to/square_1e0.prj\n```\n\n## Using the combinatorial builder\n\nCreates Docker definition files with different OpenMPI implementations and OpenGeoSys parallel configuration (from the current master), builds the docker images and converts them to Singularity images:\n\n```bash\npython build.py --ogs ufz/ogs@master --ompi 2.1.2 3.1.2 --build --convert\n```\n\nCheck help for more options:\n\n```\n$ ogscm --help\nusage: ogscm [-h] [--version] [--out OUT] [--file FILE] [--sif_file SIF_FILE] [--print]\n              [--format [{docker,singularity} [{docker,singularity} ...]]] [--pm [{system,conan,off} [{system,conan,off} ...]]]\n              [--ompi [OMPI [OMPI ...]]] [--ogs [OGS [OGS ...]]] [--cmake_args [CMAKE_ARGS [CMAKE_ARGS ...]]] [--build]\n              [--build_args BUILD_ARGS] [--upload] [--registry REGISTRY] [--tag TAG] [--convert] [--runtime-only] [--ccache]\n              [--parallel PARALLEL] [--base_image BASE_IMAGE] [--compiler COMPILER] [--compiler_version COMPILER_VERSION] [--gui] [--docs]\n              [--cvode] [--cppcheck] [--iwyy] [--gcovr] [--tfel] [--mpi_benchmarks] [--dev] [--insitu] [--pip [package [package ...]]]\n              [--packages [packages [packages ...]]] [--clean] [--deploy [DEPLOY]]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --version             show program\'s version number and exit\n  --out OUT             Output directory (default: _out)\n  --file FILE           Overwrite output recipe file name (default: )\n  --sif_file SIF_FILE   Overwrite output singularity image file name (default: )\n  --print, -P           Print the definition to stdout (default: False)\n\nCombinatorial options:\n  All combinations of the given options will be generated\n\n  --format [{docker,singularity} [{docker,singularity} ...]]\n  --pm [{system,conan,off} [{system,conan,off} ...]]\n                        Package manager to install third-party dependencies (default: [\'conan\'])\n  --ompi [OMPI [OMPI ...]]\n                        OpenMPI version, e.g. 2.1.1, 2.1.5, 3.0.1, 3.1.2 (default: [\'off\'])\n  --ogs [OGS [OGS ...]]\n                        OGS repo on gitlab.opengeosys.org in the form \'user/repo@branch\' OR \'user/repo@@commit\' to checkout a specific commit\n                        OR a path to a local subdirectory to the git cloned OGS sources OR \'off\' to disable OGS building (default:\n                        [\'ogs/ogs@master\'])\n  --cmake_args [CMAKE_ARGS [CMAKE_ARGS ...]]\n                        CMake argument sets have to be quoted and **must** start with a space. e.g. --cmake_args \' -DFIRST=TRUE -DFOO=BAR\' \'\n                        -DSECOND=TRUE\' (default: [\'\'])\n\nImage build options:\n  --build, -B           Build the images from the definition files (default: False)\n  --build_args BUILD_ARGS\n                        Arguments to the build command. Have to be quoted and **must** start with a space. E.g. --build_args \' --no-cache\'\n                        (default: )\n  --upload, -U          Upload Docker image to registry (default: False)\n  --registry REGISTRY   The docker registry the image is tagged and uploaded to. (default: registry.opengeosys.org/ogs/ogs)\n  --tag TAG             The full docker image tag. Overwrites --registry. (default: )\n  --convert, -C         Convert Docker image to Singularity image (default: False)\n  --runtime-only, -R    Generate multi-stage Dockerfiles for small runtime images (default: False)\n  --ccache              Enables ccache build caching. (default: False)\n  --parallel PARALLEL, -j PARALLEL\n                        The number of cores to use for compilation. (default: 10)\n\nAdditional options:\n  --base_image BASE_IMAGE\n                        The base image. (centos:8 is supported too) (default: ubuntu:20.04)\n  --compiler COMPILER   The compiler to use. Possible options: off, gcc, clang (default: gcc)\n  --compiler_version COMPILER_VERSION\n                        Compiler version. (default: )\n  --gui                 Builds the GUI (Data Explorer) (default: False)\n  --docs                Setup documentation requirements (Doxygen) (default: False)\n  --cvode               Install and configure with cvode (default: False)\n  --cppcheck            Install cppcheck (default: False)\n  --iwyy                Install include-what-you-use (default: False)\n  --gcovr               Install gcovr (default: False)\n  --tfel                Install tfel (default: False)\n  --mpi_benchmarks      Installs OSU MPI benchmarks as scif app and mpi_bw, mpi_ring,mpi_hello (default: False)\n  --dev                 Installs development tools (vim, gdb) (default: False)\n  --insitu              Builds with insitu capabilities (default: False)\n  --pip [package [package ...]]\n                        Install additional Python packages (default: [])\n  --packages [packages [packages ...]]\n                        Install additional OS packages (default: [])\n\nMaintenance:\n  --clean               Cleans up generated files in default directories. (default: False)\n\nImage deployment:\n  --deploy [DEPLOY], -D [DEPLOY]\n                        Deploys to all configured hosts (in config/deploy_hosts.yml) with no additional arguments or to the specified host.\n                        Implies --build and --convert arguments. (default: )\n```\n\n## Advanced usage\n\n### Build OGS from local git repo\n\nYou can use the ogs-container-maker to build multiple container images from your current source code at once. The following commands will build (`-B`-parameter) 4 docker container (using one serial and 3 MPI-enabled configurations), convert them to Singularity image files (`-C`) and strip everything out but the runtime-requirements (`-R`). You can find the images in `_out/images`.\n\n```\ncd ogs\ngit submodule update --init ThirdParty/container-maker\nvirtualenv .venv\nsource .venv/bin/activate\npip install -r ThirdParty/container-maker/requirements.txt\nexport PYTHONPATH="${PYTHONPATH}:${PWD}/ThirdParty/container-maker"\npython ThirdParty/container-maker/ogscm/cli.py -B -C -R --ogs . --pm system --cvode --ompi off 2.1.6 3.1.4 4.0.1\n```\n\n### Deploy image files\n\n- Requires `rsync`\n- Rename the file `config/deploy_hosts_example.yml` to `config/deploy_hosts.yml`\n- `host` has to be a SSH host to which you have passwordless access\n- Deploy to the host with `... -D myhost`\n\n\n## PyPi Publication\n\n- Bump version in `pyproject.py`\n- Create tag\n- Push to GitLab (`git push --tags`)\n',
    'author': 'Lars Bilke',
    'author_email': 'lars.bilke@ufz.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.opengeosys.org/ogs/container-maker',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
