"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-client-explicit-props');
const userpool = new lib_1.UserPool(stack, 'myuserpool');
userpool.addClient('myuserpoolclient', {
    userPoolClientName: 'myuserpoolclient',
    authFlows: {
        adminUserPassword: true,
        custom: true,
        refreshToken: true,
        userPassword: true,
        userSrp: true,
    },
    generateSecret: true,
    oAuth: {
        flows: {
            implicitCodeGrant: true,
            authorizationCodeGrant: true,
        },
        scopes: [
            lib_1.OAuthScope.PHONE,
            lib_1.OAuthScope.EMAIL,
            lib_1.OAuthScope.OPENID,
            lib_1.OAuthScope.PROFILE,
            lib_1.OAuthScope.COGNITO_ADMIN,
            lib_1.OAuthScope.custom('my-resource-server/my-scope'),
        ],
        callbackUrls: ['https://redirect-here.myapp.com'],
    },
});
//# sourceMappingURL=data:application/json;base64,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