MessageNS = '{http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message}'
StructureSpecificNS = '{http://www.sdmx.org/resources/sdmxml/schemas/v2_1' \
                      '/metadata/structurespecific} '
QueryNS = '{http://www.sdmx.org/resources/sdmxml/schemas/v2_1/query}'
RegistryNS = '{http://www.sdmx.org/resources/sdmxml/schemas/v2_1/registry}'
StructureNS = '{http://www.sdmx.org/resources/sdmxml/schemas/v2_1/structure}'
GenericNS = '{http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic}'
XMLInstanceNS = '{http://www.w3.org/2001/XMLSchema-instance}'

ClassToNode = {
    'AgencyType': 'Agency',
    'AnnotationsType': 'Annotations',
    'AttributeType': 'Attribute',
    'AttributeListType': 'AttributeList',
    'AttributeWhereType': 'AttributeWhere',
    'CategorisationQueryType': 'CategorisationQuery',
    'CategorisationWhereType': 'CategorisationWhere',
    'CategoryType': 'Category',
    'CategoryMapType': 'CategoryMap',
    'CategorySchemeQueryType': 'CategorySchemeQuery',
    'CategorySchemeWhereType': 'CategorySchemeWhere',
    'CategoryWhereType': 'CategoryWhere',
    'CodeType': 'Code',
    'CodeMapType': 'CodeMap',
    'CodeWhereType': 'CodeWhere',
    'CodelistQueryType': 'CodelistQuery',
    'CodelistWhereType': 'CodelistWhere',
    'ComponentType': 'Component',
    'ComponentListType': 'ComponentList',
    'ComponentListWhereType': 'ComponentListWhere',
    'ComponentWhereType': 'ComponentWhere',
    'ConceptType': 'Concept',
    'ConceptMapType': 'ConceptMap',
    'ConceptSchemeQueryType': 'ConceptSchemeQuery',
    'ConceptSchemeWhereType': 'ConceptSchemeWhere',
    'ConceptWhereType': 'ConceptWhere',
    'ConstraintContentTargetType': 'ConstraintContentTarget',
    'ConstraintQueryType': 'ConstraintQuery',
    'ConstraintWhereType': 'ConstraintWhere',
    'DataConsumerType': 'DataConsumer',
    'DataProviderType': 'DataProvider',
    'DataSchemaQueryType': 'DataSchemaQuery',
    'DataSetTargetType': 'DataSetTarget',
    'DataStructureComponentsType': 'DataStructureComponents',
    'DataStructureQueryType': 'DataStructureQuery',
    'DataStructureWhereType': 'DataStructureWhere',
    'DataflowQueryType': 'DataflowQuery',
    'DataflowWhereType': 'DataflowWhere',
    'DimensionType': 'Dimension',
    'DimensionListType': 'DimensionList',
    'DimensionWhereType': 'DimensionWhere',
    'ErrorType': 'Error',
    'FooterType': 'Footer',
    'GenericDataType': 'GenericData',
    'GenericDataQueryType': 'GenericDataQuery',
    'GenericMetadataType': 'GenericMetadata',
    'MetadataQueryType': 'GenericMetadataQuery',
    'GenericTimeSeriesDataType': 'GenericTimeSeriesData',
    'GenericTimeSeriesDataQueryType': 'GenericTimeSeriesDataQuery',
    'GroupType': 'Group',
    'GroupDimensionType': 'GroupDimension',
    'GroupWhereType': 'GroupWhere',
    'GroupingType': 'Grouping',
    'HierarchicalCodelistQueryType': 'HierarchicalCodelistQuery',
    'HierarchicalCodelistWhereType': 'HierarchicalCodelistWhere',
    'IdentifiableObjectTargetType': 'IdentifiableObjectTarget',
    'ItemType': 'Item',
    'ItemAssociationType': 'ItemAssociation',
    'ItemWhereType': 'ItemWhere',
    'KeyDescriptorValuesTargetType': 'KeyDescriptorValuesTarget',
    'MeasureDimensionType': 'MeasureDimension',
    'MeasureDimensionWhereType': 'MeasureDimensionWhere',
    'MeasureListType': 'MeasureList',
    'MetadataAttributeType': 'MetadataAttribute',
    'MetadataAttributeWhereType': 'MetadataAttributeWhere',
    'MetadataSchemaQueryType': 'MetadataSchemaQuery',
    'MetadataStructureComponentsType': 'MetadataStructureComponents',
    'MetadataStructureQueryType': 'MetadataStructureQuery',
    'MetadataStructureWhereType': 'MetadataStructureWhere',
    'MetadataTargetType': 'MetadataTarget',
    'MetadataTargetWhereType': 'MetadataTargetWhere',
    'MetadataflowQueryType': 'MetadataflowQuery',
    'MetadataflowWhereType': 'MetadataflowWhere',
    'NotifyRegistryEventType': 'NotifyRegistryEvent',
    'NumericValueType': 'NumericValue',
    'OrganisationType': 'Organisation',
    'OrganisationMapType': 'OrganisationMap',
    'OrganisationSchemeQueryType': 'OrganisationSchemeQuery',
    'OrganisationSchemeWhereType': 'OrganisationSchemeWhere',
    'OrganisationUnitType': 'OrganisationUnit',
    'OrganisationWhereType': 'OrganisationWhere',
    'PrimaryMeasureType': 'PrimaryMeasure',
    'PrimaryMeasureWhereType': 'PrimaryMeasureWhere',
    'ProcessQueryType': 'ProcessQuery',
    'ProcessWhereType': 'ProcessWhere',
    'ProvisionAgreementQueryType': 'ProvisionAgreementQuery',
    'ProvisionAgreementWhereType': 'ProvisionAgreementWhere',
    'QueryRegistrationRequestType': 'QueryRegistrationRequest',
    'QueryRegistrationResponseType': 'QueryRegistrationResponse',
    'QuerySubscriptionRequestType': 'QuerySubscriptionRequest',
    'QuerySubscriptionResponseType': 'QuerySubscriptionResponse',
    'RegistryInterfaceType': 'RegistryInterface',
    'ReportPeriodTargetType': 'ReportPeriodTarget',
    'ReportStructureType': 'ReportStructure',
    'ReportStructureWhereType': 'ReportStructureWhere',
    'ReportingCategoryType': 'ReportingCategory',
    'ReportingCategoryMapType': 'ReportingCategoryMap',
    'ReportingCategoryWhereType': 'ReportingCategoryWhere',
    'ReportingTaxonomyQueryType': 'ReportingTaxonomyQuery',
    'ReportingTaxonomyWhereType': 'ReportingTaxonomyWhere',
    'ReportingYearStartDayType': 'ReportingYearStartDay',
    'MaintainableWhereType': 'StructuralMetadataWhere',
    'StructureSetQueryType': 'StructureSetQuery',
    'StructureSetWhereType': 'StructureSetWhere',
    'StructureSpecificDataType': 'StructureSpecificData',
    'DataQueryType': 'StructureSpecificDataQuery',
    'StructureSpecificMetadataType': 'StructureSpecificMetadata',
    'StructureSpecificTimeSeriesDataType': 'StructureSpecificTimeSeriesData',
    'StructureSpecificTimeSeriesDataQueryType': 'StructureSpecific'
                                                'TimeSeriesDataQuery',
    'XHTMLType': 'StructuredText',
    'StructuresType': 'Structures',
    'StructuresQueryType': 'StructuresQuery',
    'StructuresWhereType': 'StructuresWhere',
    'SubmitRegistrationsRequestType': 'SubmitRegistrationsRequest',
    'SubmitRegistrationsResponseType': 'SubmitRegistrationsResponse',
    'SubmitStructureRequestType': 'SubmitStructureRequest',
    'SubmitStructureResponseType': 'SubmitStructureResponse',
    'SubmitSubscriptionsRequestType': 'SubmitSubscriptionsRequest',
    'SubmitSubscriptionsResponseType': 'SubmitSubscriptionsResponse',
    'TargetObjectWhereType': 'TargetObjectWhere',
    'TextType': 'Text',
    'QueryTextType': 'TextValue',
    'TimeDimensionType': 'TimeDimension',
    'TimeDimensionWhereType': 'TimeDimensionWhere',
    'TimePeriodValueType': 'TimeValue',
    'SimpleValueType': 'Value',
    'ValuesType': "Attributes",
    'ObsType': 'Obs',
    'SeriesType': 'Series',
    'Sender': 'Sender',
    'Party': 'Receiver',
    'StructureType': 'Structure',
    'GenericDataStructureType': 'Structure',
    'DataSetType': 'DataSet',
    'StructureDataSetType': 'DataSet',
    'StructureSpecificDataHeaderType': 'Header',
    'GenericDataHeaderType': 'Header',
    'GenericTimeSeriesDataHeaderType': 'Header',
    'StructureSpecificTimeSeriesDataHeaderType': 'Header',
    'TimeSeriesDataSetType': 'DataSet'
}

RenameMappings_ = {
    f"{XMLInstanceNS}dim_type": "Type",
    f"{GenericNS}GroupType": "GroupType9",
    f"{StructureSpecificNS}DataSetType": "DataSetType10",
    f"{StructureSpecificNS}GroupType": "GroupType11",
    f"{StructureSpecificNS}ObsType": "ObsType13",
    f"{StructureSpecificNS}SeriesType": "SeriesType12",
    f"{StructureSpecificNS}TimeSeriesDataSetType": "TimeSeriesDataSetType14",
    f"{StructureSpecificNS}TimeSeriesObsType": "TimeSeriesObsType16",
    f"{StructureSpecificNS}TimeSeriesType": "TimeSeriesType15",
    f"{MessageNS}CategorisationQueryType": "CategorisationQueryType53",
    f"{MessageNS}CategorySchemeQueryType": "CategorySchemeQueryType45",
    f"{MessageNS}CodelistQueryType": "CodelistQueryType47",
    f"{MessageNS}ConceptSchemeQueryType": "ConceptSchemeQueryType46",
    f"{MessageNS}ConstraintQueryType": "ConstraintQueryType55",
    f"{MessageNS}ContactType": "ContactType56",
    f"{MessageNS}DataQueryType": "DataQueryType34",
    f"{MessageNS}DataSchemaQueryType": "DataSchemaQueryType38",
    f"{MessageNS}DataStructureQueryType": "DataStructureQueryType43",
    f"{MessageNS}DataflowQueryType": "DataflowQueryType41",
    f"{MessageNS}GenericDataQueryType": "GenericDataQueryType35",
    f"{MessageNS}GenericTimeSeriesDataQueryType": "GenericTimeSeries"
                                                  "DataQueryType36",
    f"{MessageNS}HierarchicalCodelistQueryType": "HierarchicalCodelist"
                                                 "QueryType48",
    f"{MessageNS}MetadataQueryType": "MetadataQueryType37",
    f"{MessageNS}MetadataSchemaQueryType": "MetadataSchemaQueryType39",
    f"{MessageNS}MetadataStructureQueryType": "MetadataStructureQueryType44",
    f"{MessageNS}MetadataflowQueryType": "MetadataflowQueryType42",
    f"{MessageNS}NotifyRegistryEventType": "NotifyRegistryEventType33",
    f"{MessageNS}OrganisationSchemeQueryType": "OrganisationSchemeQueryType49",
    f"{MessageNS}ProcessQueryType": "ProcessQueryType52",
    f"{MessageNS}ProvisionAgreementQueryType": "ProvisionAgreementQueryType54",
    f"{MessageNS}QueryRegistrationRequestType": "QueryRegistration"
                                                "RequestType25",
    f"{MessageNS}QueryRegistrationResponseType": "QueryRegistration"
                                                 "ResponseType26",
    f"{MessageNS}QuerySubscriptionRequestType": "QuerySubscription"
                                                "RequestType31",
    f"{MessageNS}QuerySubscriptionResponseType": "QuerySubscription"
                                                 "ResponseType32",
    f"{MessageNS}ReportingTaxonomyQueryType": "ReportingTaxonomyQueryType50",
    f"{MessageNS}StructureSetQueryType": "StructureSetQueryType51",
    f"{MessageNS}StructureType": "StructureType22",
    f"{MessageNS}StructuresQueryType": "StructuresQueryType40",
    f"{MessageNS}SubmitRegistrationsRequestType": "SubmitRegistrations"
                                                  "RequestType23",
    f"{MessageNS}SubmitRegistrationsResponseType": "SubmitRegistrations"
                                                   "ResponseType24",
    f"{MessageNS}SubmitStructureRequestType": "SubmitStructureRequestType27",
    f"{MessageNS}SubmitStructureResponseType": "SubmitStructureResponseType28",
    f"{MessageNS}SubmitSubscriptionsRequestType": "SubmitSubscriptions"
                                                  "RequestType29",
    f"{MessageNS}SubmitSubscriptionsResponseType": "SubmitSubscriptions"
                                                   "ResponseType30",
    f"{StructureSpecificNS}MetadataSetType": "MetadataSetType17",
    f"{StructureSpecificNS}ReferenceValueType": "ReferenceValueType20",
    f"{StructureSpecificNS}ReportType": "ReportType18",
    f"{StructureSpecificNS}ReportedAttributeType": "ReportedAttributeType21",
    f"{StructureSpecificNS}TargetType": "TargetType19",
    f"{QueryNS}ConstraintTypeCodelistType": "ConstraintTypeCodelistType4",
    f"{QueryNS}DataStructureRequestType": "DataStructureRequestType5",
    f"{QueryNS}SimpleValueType": "SimpleValueType3",
    f"{RegistryNS}QueryableDataSourceType": "QueryableDataSourceType6",
    f"{RegistryNS}StatusMessageType": "StatusMessageType7",
    f"{RegistryNS}VersionQueryType": "VersionQueryType8",
    f"{StructureNS}DataStructureType": "DataStructureType1",
    f"{StructureNS}MetadataStructureType": "MetadataStructureType2",
}

# Definitions for the abbreviations of the namespaces

messageAbbr = 'mes'
genericAbbr = 'gen'
commonAbbr = 'com'
structureAbbr = 'str'
structureSpecificAbbr = 'ss'

GenerateDSNamespaceDefs = dict(
    GenericDataType=f'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" '
                    f'xmlns:{messageAbbr}="http://www.sdmx.org/resources'
                    f'/sdmxml/schemas/v2_1/message" '
                    f'xmlns:{genericAbbr}="http://www.sdmx.org/resources'
                    f'/sdmxml/schemas/v2_1/data/generic" '
                    f'xmlns:{commonAbbr}="http://www.sdmx.org/resources'
                    f'/sdmxml/schemas/v2_1/common" '
                    f'xsi:schemaLocation="http://www.sdmx.org/resources'
                    f'/sdmxml/schemas/v2_1/message '
                    f'https://registry.sdmx.org/schemas/v2_1/SDMXMessage.xsd"',
    StructureDataType=f'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" '
                      f'xmlns:{messageAbbr}="http://www.sdmx.org/resources'
                      f'/sdmxml/schemas/v2_1/message" '
                      f'xmlns:{genericAbbr}="http://www.sdmx.org/resources'
                      f'/sdmxml/schemas/v2_1/data/generic" '
                      f'xmlns:{commonAbbr}="http://www.sdmx.org/resources'
                      f'/sdmxml/schemas/v2_1/common" '
                      f'xsi:schemaLocation="http://www.sdmx.org/resources'
                      f'/sdmxml/schemas/v2_1/message '
                      f'https://registry.sdmx.org/schemas/v2_1/'
                      f'SDMXMessage.xsd"',
    GenericTimeSeriesDataType=f'xmlns:xsi="http://www.w3.org/2001/XMLSchema'
                              f'-instance" '
                              f'xmlns:{messageAbbr}="http://www.sdmx.org'
                              f'/resources/sdmxml/schemas/v2_1/message" '
                              f'xmlns:{genericAbbr}="http://www.sdmx.org'
                              f'/resources/sdmxml/schemas/v2_1/data '
                              f'/generic" '
                              f'xmlns:{commonAbbr}="http://www.sdmx.org'
                              f'/resources/sdmxml/schemas/v2_1/common" '
                              f'xsi:schemaLocation="http://www.sdmx.org'
                              f'/resources/sdmxml/schemas/v2_1/message '
                              f'https://registry.sdmx.org/schemas/v2_1'
                              f'/SDMXMessage.xsd"',
    StructureTimeSeriesDataType=f'xmlns:xsi="http://www.w3.org/2001'
                                f'/XMLSchema-instance" '
                                f'xmlns:{messageAbbr}="http://www.sdmx.org'
                                f'/resources/sdmxml/schemas/v2_1/message" '
                                f'xmlns:{genericAbbr}="http://www.sdmx.org'
                                f'/resources/sdmxml/schemas/v2_1/data '
                                f'/generic" '
                                f'xmlns:{commonAbbr}="http://www.sdmx.org'
                                f'/resources/sdmxml/schemas/v2_1/common" '
                                f'xsi:schemaLocation="http://www.sdmx.org'
                                f'/resources/sdmxml/schemas/v2_1/message '
                                f'https://registry.sdmx.org/schemas/v2_1'
                                f'/SDMXMessage.xsd"',
    Structure=f'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" '
              f'xmlns:{messageAbbr}="http://www.sdmx.org/resources/sdmxml'
              f'/schemas/v2_1/message" '
              f'xmlns:{structureAbbr}="http://www.sdmx.org/resources/sdmxml'
              f'/schemas/v2_1/structure" '
              f'xmlns:{commonAbbr}="http://www.sdmx.org/resources/sdmxml'
              f'/schemas/v2_1/common" '
              f'xsi:schemaLocation="http://www.sdmx.org/resources/sdmxml'
              f'/schemas/v2_1/message '
              f'https://registry.sdmx.org/schemas/v2_1/SDMXMessage.xsd"')

ClassToPrefix = {
    'AgencyType': 'Agency',
    'AnnotationsType': 'Annotations',
    'AttributeType': 'Attribute',
    'AttributeListType': 'AttributeList',
    'AttributeWhereType': 'AttributeWhere',
    'CategorisationQueryType': 'CategorisationQuery',
    'CategorisationWhereType': 'CategorisationWhere',
    'CategoryType': 'Category',
    'CategoryMapType': 'CategoryMap',
    'CategorySchemeQueryType': 'CategorySchemeQuery',
    'CategorySchemeWhereType': 'CategorySchemeWhere',
    'CategoryWhereType': 'CategoryWhere',
    'CodeType': 'Code',
    'CodeMapType': 'CodeMap',
    'CodeWhereType': 'CodeWhere',
    'CodelistQueryType': 'CodelistQuery',
    'CodelistWhereType': 'CodelistWhere',
    'ComponentType': 'Component',
    'ComponentListType': 'ComponentList',
    'ComponentListWhereType': 'ComponentListWhere',
    'ComponentWhereType': 'ComponentWhere',
    'ConceptType': 'Concept',
    'ConceptMapType': 'ConceptMap',
    'ConceptSchemeQueryType': 'ConceptSchemeQuery',
    'ConceptSchemeWhereType': 'ConceptSchemeWhere',
    'ConceptWhereType': 'ConceptWhere',
    'ConstraintContentTargetType': 'ConstraintContentTarget',
    'ConstraintQueryType': 'ConstraintQuery',
    'ConstraintWhereType': 'ConstraintWhere',
    'DataConsumerType': 'DataConsumer',
    'DataProviderType': 'DataProvider',
    'DataSchemaQueryType': 'DataSchemaQuery',
    'DataSetTargetType': 'DataSetTarget',
    'DataStructureComponentsType': 'DataStructureComponents',
    'DataStructureQueryType': 'DataStructureQuery',
    'DataStructureWhereType': 'DataStructureWhere',
    'DataflowQueryType': 'DataflowQuery',
    'DataflowWhereType': 'DataflowWhere',
    'DimensionType': 'Dimension',
    'DimensionListType': 'DimensionList',
    'DimensionWhereType': 'DimensionWhere',
    'ErrorType': 'Error',
    'FooterType': 'Footer',
    'GenericDataType': 'GenericData',
    'GenericDataQueryType': 'GenericDataQuery',
    'GenericMetadataType': 'GenericMetadata',
    'MetadataQueryType': 'GenericMetadataQuery',
    'GenericTimeSeriesDataType': 'GenericTimeSeriesData',
    'GenericTimeSeriesDataQueryType': 'GenericTimeSeriesDataQuery',
    'GroupType': 'Group',
    'GroupDimensionType': 'GroupDimension',
    'GroupWhereType': 'GroupWhere',
    'GroupingType': 'Grouping',
    'HierarchicalCodelistQueryType': 'HierarchicalCodelistQuery',
    'HierarchicalCodelistWhereType': 'HierarchicalCodelistWhere',
    'IdentifiableObjectTargetType': 'IdentifiableObjectTarget',
    'ItemType': 'Item',
    'ItemAssociationType': 'ItemAssociation',
    'ItemWhereType': 'ItemWhere',
    'KeyDescriptorValuesTargetType': 'KeyDescriptorValuesTarget',
    'MeasureDimensionType': 'MeasureDimension',
    'MeasureDimensionWhereType': 'MeasureDimensionWhere',
    'MeasureListType': 'MeasureList',
    'MetadataAttributeType': 'MetadataAttribute',
    'MetadataAttributeWhereType': 'MetadataAttributeWhere',
    'MetadataSchemaQueryType': 'MetadataSchemaQuery',
    'MetadataStructureComponentsType': 'MetadataStructureComponents',
    'MetadataStructureQueryType': 'MetadataStructureQuery',
    'MetadataStructureWhereType': 'MetadataStructureWhere',
    'MetadataTargetType': 'MetadataTarget',
    'MetadataTargetWhereType': 'MetadataTargetWhere',
    'MetadataflowQueryType': 'MetadataflowQuery',
    'MetadataflowWhereType': 'MetadataflowWhere',
    'NotifyRegistryEventType': 'NotifyRegistryEvent',
    'NumericValueType': 'NumericValue',
    'OrganisationType': 'Organisation',
    'OrganisationMapType': 'OrganisationMap',
    'OrganisationSchemeQueryType': 'OrganisationSchemeQuery',
    'OrganisationSchemeWhereType': 'OrganisationSchemeWhere',
    'OrganisationUnitType': 'OrganisationUnit',
    'OrganisationWhereType': 'OrganisationWhere',
    'PrimaryMeasureType': 'PrimaryMeasure',
    'PrimaryMeasureWhereType': 'PrimaryMeasureWhere',
    'ProcessQueryType': 'ProcessQuery',
    'ProcessWhereType': 'ProcessWhere',
    'ProvisionAgreementQueryType': 'ProvisionAgreementQuery',
    'ProvisionAgreementWhereType': 'ProvisionAgreementWhere',
    'QueryRegistrationRequestType': 'QueryRegistrationRequest',
    'QueryRegistrationResponseType': 'QueryRegistrationResponse',
    'QuerySubscriptionRequestType': 'QuerySubscriptionRequest',
    'QuerySubscriptionResponseType': 'QuerySubscriptionResponse',
    'RegistryInterfaceType': 'RegistryInterface',
    'ReportPeriodTargetType': 'ReportPeriodTarget',
    'ReportStructureType': 'ReportStructure',
    'ReportStructureWhereType': 'ReportStructureWhere',
    'ReportingCategoryType': 'ReportingCategory',
    'ReportingCategoryMapType': 'ReportingCategoryMap',
    'ReportingCategoryWhereType': 'ReportingCategoryWhere',
    'ReportingTaxonomyQueryType': 'ReportingTaxonomyQuery',
    'ReportingTaxonomyWhereType': 'ReportingTaxonomyWhere',
    'ReportingYearStartDayType': 'ReportingYearStartDay',
    'MaintainableWhereType': 'StructuralMetadataWhere',
    'StructureType': 'Structure',
    'StructureSetQueryType': 'StructureSetQuery',
    'StructureSetWhereType': 'StructureSetWhere',
    'StructureSpecificDataType': 'StructureSpecificData',
    'DataQueryType': 'StructureSpecificDataQuery',
    'StructureSpecificMetadataType': 'StructureSpecificMetadata',
    'StructureSpecificTimeSeriesDataType': 'StructureSpecificTimeSeriesData',
    'StructureSpecificTimeSeriesDataQueryType': 'StructureSpecific'
                                                'TimeSeriesDataQuery',
    'XHTMLType': 'StructuredText',
    'StructuresType': 'Structures',
    'StructuresQueryType': 'StructuresQuery',
    'StructuresWhereType': 'StructuresWhere',
    'SubmitRegistrationsRequestType': 'SubmitRegistrationsRequest',
    'SubmitRegistrationsResponseType': 'SubmitRegistrationsResponse',
    'SubmitStructureRequestType': 'SubmitStructureRequest',
    'SubmitStructureResponseType': 'SubmitStructureResponse',
    'SubmitSubscriptionsRequestType': 'SubmitSubscriptionsRequest',
    'SubmitSubscriptionsResponseType': 'SubmitSubscriptionsResponse',
    'TargetObjectWhereType': 'TargetObjectWhere',
    'TextType': 'Text',
    'QueryTextType': 'TextValue',
    'TimeDimensionType': 'TimeDimension',
    'TimeDimensionWhereType': 'TimeDimensionWhere',
    'TimePeriodValueType': 'TimeValue',
    'SimpleValueType': 'Value',
    'StructureSpecificDataHeaderType': 'Header',
    'StructureDataSetType': 'DataSet',
    'ObsType': 'Obs',
    'SeriesType': 'Series',
    'Sender': 'Sender',
    'Party': 'Receiver',
    'DataSetType': 'message',
    'GenericDataStructureType': 'Structure',
    'ValuesType': "Attributes",
    'GenericDataHeaderType': 'message'
}

Data_Types_VTL = {
    "String": "String",
    "Alpha": "String",
    "AlphaNumeric": "String",
    "Numeric": "String",
    "BigInteger": "Integer",
    "Integer": "Integer",
    "Long": "Integer",
    "Short": "Integer",
    "Decimal": "Number",
    "Float": "Number",
    "Double": "Number",
    "Boolean": "Boolean",
    "URI": "String",
    "Count": "Integer",
    "InclusiveValueRange": "Number",
    "ExclusiveValueRange": "Number",
    "Incremental": "Number",
    "ObservationalTimePeriod": "Date",
    "StandardTimePeriod": "Date",
    "BasicTimePeriod": "Date",
    "GregorianTimePeriod": "Date",
    "GregorianYear": "Date",
    "GregorianYearMonth": "Date",
    "GregorianMonth": "Date",
    "GregorianDay": "Date",
    "ReportingTimePeriod": "TimePeriod",
    "ReportingYear": "TimePeriod",
    "ReportingSemester": "TimePeriod",
    "ReportingTrimester": "TimePeriod",
    "ReportingQuarter": "TimePeriod",
    "ReportingMonth": "TimePeriod",
    "ReportingWeek": "TimePeriod",
    "ReportingDay": "TimePeriod",
    "DateTime": "Date",
    "TimeRange": "Time",
    "Month": "String",
    "MonthDay": "String",
    "Day": "String",
    "Time": "String",
    "Duration": "Duration"
}

Locale_Codes = {
    'ab': 'Abkhaz',
    'aa': 'Afar',
    'af': 'Afrikaans',
    'ak': 'Akan',
    'sq': 'Albanian',
    'am': 'Amharic',
    'ar': 'Arabic',
    'an': 'Aragonese',
    'hy': 'Armenian',
    'as': 'Assamese',
    'av': 'Avaric',
    'ae': 'Avestan',
    'ay': 'Aymara',
    'az': 'Azerbaijani',
    'bm': 'Bambara',
    'ba': 'Bashkir',
    'eu': 'Basque',
    'be': 'Belarusian',
    'bn': 'Bengali',
    'bh': 'Bihari',
    'bi': 'Bislama',
    'bs': 'Bosnian',
    'br': 'Breton',
    'bg': 'Bulgarian',
    'my': 'Burmese',
    'ca': 'Catalan; Valencian',
    'ch': 'Chamorro',
    'ce': 'Chechen',
    'ny': 'Chichewa; Chewa; Nyanja',
    'zh': 'Chinese',
    'cv': 'Chuvash',
    'kw': 'Cornish',
    'co': 'Corsican',
    'cr': 'Cree',
    'hr': 'Croatian',
    'cs': 'Czech',
    'da': 'Danish',
    'dv': 'Divehi; Maldivian;',
    'nl': 'Dutch',
    'dz': 'Dzongkha',
    'en': 'English',
    'eo': 'Esperanto',
    'et': 'Estonian',
    'ee': 'Ewe',
    'fo': 'Faroese',
    'fj': 'Fijian',
    'fi': 'Finnish',
    'fr': 'French',
    'ff': 'Fula',
    'gl': 'Galician',
    'ka': 'Georgian',
    'de': 'German',
    'el': 'Greek, Modern',
    'gn': 'Guaraní',
    'gu': 'Gujarati',
    'ht': 'Haitian',
    'ha': 'Hausa',
    'he': 'Hebrew modern',
    'hz': 'Herero',
    'hi': 'Hindi',
    'ho': 'Hiri Motu',
    'hu': 'Hungarian',
    'ia': 'Interlingua',
    'id': 'Indonesian',
    'ie': 'Interlingue',
    'ga': 'Irish',
    'ig': 'Igbo',
    'ik': 'Inupiaq',
    'io': 'Ido',
    'is': 'Icelandic',
    'it': 'Italian',
    'iu': 'Inuktitut',
    'ja': 'Japanese',
    'jv': 'Javanese',
    'kl': 'Kalaallisut',
    'kn': 'Kannada',
    'kr': 'Kanuri',
    'ks': 'Kashmiri',
    'kk': 'Kazakh',
    'km': 'Khmer',
    'ki': 'Kikuyu, Gikuyu',
    'rw': 'Kinyarwanda',
    'ky': 'Kirghiz, Kyrgyz',
    'kv': 'Komi',
    'kg': 'Kongo',
    'ko': 'Korean',
    'ku': 'Kurdish',
    'kj': 'Kwanyama, Kuanyama',
    'la': 'Latin',
    'lb': 'Luxembourgish',
    'lg': 'Luganda',
    'li': 'Limburgish',
    'ln': 'Lingala',
    'lo': 'Lao',
    'lt': 'Lithuanian',
    'lu': 'Luba-Katanga',
    'lv': 'Latvian',
    'gv': 'Manx',
    'mk': 'Macedonian',
    'mg': 'Malagasy',
    'ms': 'Malay',
    'ml': 'Malayalam',
    'mt': 'Maltese',
    'mi': 'Māori',
    'mr': 'Marathi Marāṭhī',
    'mh': 'Marshallese',
    'mn': 'Mongolian',
    'na': 'Nauru',
    'nv': 'Navajo, Navaho',
    'nb': 'Norwegian Bokmål',
    'nd': 'North Ndebele',
    'ne': 'Nepali',
    'ng': 'Ndonga',
    'nn': 'Norwegian Nynorsk',
    'no': 'Norwegian',
    'ii': 'Nuosu',
    'nr': 'South Ndebele',
    'oc': 'Occitan',
    'oj': 'Ojibwe, Ojibwa',
    'cu': 'Old Church Slavonic',
    'om': 'Oromo',
    'or': 'Oriya',
    'os': 'Ossetian, Ossetic',
    'pa': 'Panjabi, Punjabi',
    'pi': 'Pāli',
    'fa': 'Persian',
    'pl': 'Polish',
    'ps': 'Pashto, Pushto',
    'pt': 'Portuguese',
    'qu': 'Quechua',
    'rm': 'Romansh',
    'rn': 'Kirundi',
    'ro': 'Romanian, Moldavan',
    'ru': 'Russian',
    'sa': 'Sanskrit Saṁskṛta',
    'sc': 'Sardinian',
    'sd': 'Sindhi',
    'se': 'Northern Sami',
    'sm': 'Samoan',
    'sg': 'Sango',
    'sr': 'Serbian',
    'gd': 'Scottish Gaelic',
    'sn': 'Shona',
    'si': 'Sinhala, Sinhalese',
    'sk': 'Slovak',
    'sl': 'Slovene',
    'so': 'Somali',
    'st': 'Southern Sotho',
    'es': 'Spanish; Castilian',
    'su': 'Sundanese',
    'sw': 'Swahili',
    'ss': 'Swati',
    'sv': 'Swedish',
    'ta': 'Tamil',
    'te': 'Telugu',
    'tg': 'Tajik',
    'th': 'Thai',
    'ti': 'Tigrinya',
    'bo': 'Tibetan',
    'tk': 'Turkmen',
    'tl': 'Tagalog',
    'tn': 'Tswana',
    'to': 'Tonga',
    'tr': 'Turkish',
    'ts': 'Tsonga',
    'tt': 'Tatar',
    'tw': 'Twi',
    'ty': 'Tahitian',
    'ug': 'Uighur, Uyghur',
    'uk': 'Ukrainian',
    'ur': 'Urdu',
    'uz': 'Uzbek',
    've': 'Venda',
    'vi': 'Vietnamese',
    'vo': 'Volapük',
    'wa': 'Walloon',
    'cy': 'Welsh',
    'wo': 'Wolof',
    'fy': 'Western Frisian',
    'xh': 'Xhosa',
    'yi': 'Yiddish',
    'yo': 'Yoruba',
    'za': 'Zhuang, Chuang',
    'zu': 'Zulu',
}
