"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynchronizationJob = exports.SynchronizationJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "SynchronizationJobProperty", { enumerable: true, get: function () { return dts_generated_1.RosSynchronizationJob; } });
/**
 * A ROS resource type:  `ALIYUN::DTS::SynchronizationJob`
 */
class SynchronizationJob extends ros.Resource {
    /**
     * Create a new `ALIYUN::DTS::SynchronizationJob`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSynchronizationJob = new dts_generated_1.RosSynchronizationJob(this, id, {
            synchronizationObjects: props.synchronizationObjects,
            period: props.period,
            payType: props.payType ? props.payType : 'Postpaid',
            topology: props.topology,
            sourceRegion: props.sourceRegion,
            dataInitialization: props.dataInitialization ? props.dataInitialization : true,
            destinationEndpoint: props.destinationEndpoint,
            networkType: props.networkType,
            sourceEndpoint: props.sourceEndpoint,
            usedTime: props.usedTime,
            structureInitialization: props.structureInitialization ? props.structureInitialization : true,
            synchronizationJobClass: props.synchronizationJobClass,
            destRegion: props.destRegion,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSynchronizationJob;
        this.attrSynchronizationJobId = rosSynchronizationJob.attrSynchronizationJobId;
    }
}
exports.SynchronizationJob = SynchronizationJob;
//# sourceMappingURL=data:application/json;base64,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