"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationJob = exports.MigrationJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "MigrationJobProperty", { enumerable: true, get: function () { return dts_generated_1.RosMigrationJob; } });
/**
 * A ROS resource type:  `ALIYUN::DTS::MigrationJob`
 */
class MigrationJob extends ros.Resource {
    /**
     * Create a new `ALIYUN::DTS::MigrationJob`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMigrationJob = new dts_generated_1.RosMigrationJob(this, id, {
            migrationObject: props.migrationObject,
            destinationEndpoint: props.destinationEndpoint,
            migrationJobClass: props.migrationJobClass,
            sourceEndpoint: props.sourceEndpoint,
            migrationJobName: props.migrationJobName,
            migrationMode: props.migrationMode,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMigrationJob;
        this.attrMigrationJobId = rosMigrationJob.attrMigrationJobId;
    }
}
exports.MigrationJob = MigrationJob;
//# sourceMappingURL=data:application/json;base64,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