"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosSynchronizationJob = exports.RosMigrationJob = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosMigrationJobProps`
 *
 * @param properties - the TypeScript properties of a `RosMigrationJobProps`
 *
 * @returns the result of the validation.
 */
function RosMigrationJobPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('migrationObject', ros.listValidator(RosMigrationJob_MigrationObjectPropertyValidator))(properties.migrationObject));
    errors.collect(ros.propertyValidator('destinationEndpoint', RosMigrationJob_DestinationEndpointPropertyValidator)(properties.destinationEndpoint));
    errors.collect(ros.propertyValidator('migrationJobClass', ros.requiredValidator)(properties.migrationJobClass));
    errors.collect(ros.propertyValidator('migrationJobClass', ros.validateString)(properties.migrationJobClass));
    errors.collect(ros.propertyValidator('sourceEndpoint', RosMigrationJob_SourceEndpointPropertyValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('migrationJobName', ros.validateString)(properties.migrationJobName));
    errors.collect(ros.propertyValidator('migrationMode', RosMigrationJob_MigrationModePropertyValidator)(properties.migrationMode));
    return errors.wrap('supplied properties not correct for "RosMigrationJobProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob` resource
 *
 * @param properties - the TypeScript properties of a `RosMigrationJobProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosMigrationJobPropsValidator(properties).assertSuccess();
    }
    return {
        MigrationJobClass: ros.stringToRosTemplate(properties.migrationJobClass),
        DestinationEndpoint: rosMigrationJobDestinationEndpointPropertyToRosTemplate(properties.destinationEndpoint),
        MigrationJobName: ros.stringToRosTemplate(properties.migrationJobName),
        MigrationMode: rosMigrationJobMigrationModePropertyToRosTemplate(properties.migrationMode),
        MigrationObject: ros.listMapper(rosMigrationJobMigrationObjectPropertyToRosTemplate)(properties.migrationObject),
        SourceEndpoint: rosMigrationJobSourceEndpointPropertyToRosTemplate(properties.sourceEndpoint),
    };
}
/**
 * A ROS template type:  `ALIYUN::DTS::MigrationJob`
 */
class RosMigrationJob extends ros.RosResource {
    /**
     * Create a new `ALIYUN::DTS::MigrationJob`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosMigrationJob.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrMigrationJobId = ros.Token.asString(this.getAtt('MigrationJobId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.migrationJobClass = props.migrationJobClass;
        this.destinationEndpoint = props.destinationEndpoint;
        this.migrationJobName = props.migrationJobName;
        this.migrationMode = props.migrationMode;
        this.migrationObject = props.migrationObject;
        this.sourceEndpoint = props.sourceEndpoint;
    }
    get rosProperties() {
        return {
            migrationJobClass: this.migrationJobClass,
            destinationEndpoint: this.destinationEndpoint,
            migrationJobName: this.migrationJobName,
            migrationMode: this.migrationMode,
            migrationObject: this.migrationObject,
            sourceEndpoint: this.sourceEndpoint,
        };
    }
    renderProperties(props) {
        return rosMigrationJobPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosMigrationJob = RosMigrationJob;
/**
 * The resource type name for this resource class.
 */
RosMigrationJob.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::MigrationJob";
/**
 * Determine whether the given properties match those of a `ColumnExcludesProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnExcludesProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_ColumnExcludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('columnName', ros.validateString)(properties.columnName));
    return errors.wrap('supplied properties not correct for "ColumnExcludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.ColumnExcludes` resource
 *
 * @param properties - the TypeScript properties of a `ColumnExcludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.ColumnExcludes` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobColumnExcludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_ColumnExcludesPropertyValidator(properties).assertSuccess();
    return {
        ColumnName: ros.stringToRosTemplate(properties.columnName),
    };
}
/**
 * Determine whether the given properties match those of a `ColumnIncludesProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnIncludesProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_ColumnIncludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('newColumnName', ros.validateString)(properties.newColumnName));
    errors.collect(ros.propertyValidator('columnName', ros.validateString)(properties.columnName));
    return errors.wrap('supplied properties not correct for "ColumnIncludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.ColumnIncludes` resource
 *
 * @param properties - the TypeScript properties of a `ColumnIncludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.ColumnIncludes` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobColumnIncludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_ColumnIncludesPropertyValidator(properties).assertSuccess();
    return {
        NewColumnName: ros.stringToRosTemplate(properties.newColumnName),
        ColumnName: ros.stringToRosTemplate(properties.columnName),
    };
}
/**
 * Determine whether the given properties match those of a `DestinationEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_DestinationEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('userName', ros.requiredValidator)(properties.userName));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('region', ros.requiredValidator)(properties.region));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    if (properties.instanceType && (typeof properties.instanceType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceType', ros.validateAllowedValues)({
            data: properties.instanceType,
            allowedValues: ["RDS", "ECS", "LocalInstance", "MongoDB", "Redis", "DRDS", "PetaData", "OceanBase", "POLARDB"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.engineName && (typeof properties.engineName) !== 'object') {
        errors.collect(ros.propertyValidator('engineName', ros.validateAllowedValues)({
            data: properties.engineName,
            allowedValues: ["MySQL", "SQLServer", "PostgreSQL", "PPAS", "MongoDB", "Redis"],
        }));
    }
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('password', ros.requiredValidator)(properties.password));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "DestinationEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.DestinationEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.DestinationEndpoint` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobDestinationEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_DestinationEndpointPropertyValidator(properties).assertSuccess();
    return {
        Role: ros.stringToRosTemplate(properties.role),
        UserName: ros.stringToRosTemplate(properties.userName),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `MigrationModeProperty`
 *
 * @param properties - the TypeScript properties of a `MigrationModeProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_MigrationModePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('structureIntialization', ros.validateBoolean)(properties.structureIntialization));
    errors.collect(ros.propertyValidator('dataSynchronization', ros.validateBoolean)(properties.dataSynchronization));
    errors.collect(ros.propertyValidator('dataIntialization', ros.validateBoolean)(properties.dataIntialization));
    return errors.wrap('supplied properties not correct for "MigrationModeProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.MigrationMode` resource
 *
 * @param properties - the TypeScript properties of a `MigrationModeProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.MigrationMode` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobMigrationModePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_MigrationModePropertyValidator(properties).assertSuccess();
    return {
        StructureIntialization: ros.booleanToRosTemplate(properties.structureIntialization),
        DataSynchronization: ros.booleanToRosTemplate(properties.dataSynchronization),
        DataIntialization: ros.booleanToRosTemplate(properties.dataIntialization),
    };
}
/**
 * Determine whether the given properties match those of a `MigrationObjectProperty`
 *
 * @param properties - the TypeScript properties of a `MigrationObjectProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_MigrationObjectPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tableIncludes', ros.listValidator(RosMigrationJob_TableIncludesPropertyValidator))(properties.tableIncludes));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('tableExcludes', ros.listValidator(RosMigrationJob_TableExcludesPropertyValidator))(properties.tableExcludes));
    errors.collect(ros.propertyValidator('schemaName', ros.validateString)(properties.schemaName));
    errors.collect(ros.propertyValidator('newSchemaName', ros.validateString)(properties.newSchemaName));
    errors.collect(ros.propertyValidator('newDbName', ros.validateString)(properties.newDbName));
    return errors.wrap('supplied properties not correct for "MigrationObjectProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.MigrationObject` resource
 *
 * @param properties - the TypeScript properties of a `MigrationObjectProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.MigrationObject` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobMigrationObjectPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_MigrationObjectPropertyValidator(properties).assertSuccess();
    return {
        TableIncludes: ros.listMapper(rosMigrationJobTableIncludesPropertyToRosTemplate)(properties.tableIncludes),
        DBName: ros.stringToRosTemplate(properties.dbName),
        TableExcludes: ros.listMapper(rosMigrationJobTableExcludesPropertyToRosTemplate)(properties.tableExcludes),
        SchemaName: ros.stringToRosTemplate(properties.schemaName),
        NewSchemaName: ros.stringToRosTemplate(properties.newSchemaName),
        NewDBName: ros.stringToRosTemplate(properties.newDbName),
    };
}
/**
 * Determine whether the given properties match those of a `SourceEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_SourceEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('oracleSid', ros.validateString)(properties.oracleSid));
    errors.collect(ros.propertyValidator('userName', ros.requiredValidator)(properties.userName));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('region', ros.requiredValidator)(properties.region));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    if (properties.instanceType && (typeof properties.instanceType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceType', ros.validateAllowedValues)({
            data: properties.instanceType,
            allowedValues: ["RDS", "ECS", "LocalInstance", "Express", "MongoDB", "POLARDB"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.engineName && (typeof properties.engineName) !== 'object') {
        errors.collect(ros.propertyValidator('engineName', ros.validateAllowedValues)({
            data: properties.engineName,
            allowedValues: ["MySQL", "SQLServer", "PostgreSQL", "Oracle", "MongoDB", "Redis"],
        }));
    }
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('password', ros.requiredValidator)(properties.password));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "SourceEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.SourceEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.SourceEndpoint` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobSourceEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_SourceEndpointPropertyValidator(properties).assertSuccess();
    return {
        Role: ros.stringToRosTemplate(properties.role),
        OracleSID: ros.stringToRosTemplate(properties.oracleSid),
        UserName: ros.stringToRosTemplate(properties.userName),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `TableExcludesProperty`
 *
 * @param properties - the TypeScript properties of a `TableExcludesProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_TableExcludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tableName', ros.validateString)(properties.tableName));
    return errors.wrap('supplied properties not correct for "TableExcludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.TableExcludes` resource
 *
 * @param properties - the TypeScript properties of a `TableExcludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.TableExcludes` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobTableExcludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_TableExcludesPropertyValidator(properties).assertSuccess();
    return {
        TableName: ros.stringToRosTemplate(properties.tableName),
    };
}
/**
 * Determine whether the given properties match those of a `TableIncludesProperty`
 *
 * @param properties - the TypeScript properties of a `TableIncludesProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob_TableIncludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tableName', ros.validateString)(properties.tableName));
    errors.collect(ros.propertyValidator('filterCondition', ros.validateString)(properties.filterCondition));
    errors.collect(ros.propertyValidator('columnExcludes', ros.listValidator(RosMigrationJob_ColumnExcludesPropertyValidator))(properties.columnExcludes));
    errors.collect(ros.propertyValidator('columnIncludes', ros.listValidator(RosMigrationJob_ColumnIncludesPropertyValidator))(properties.columnIncludes));
    errors.collect(ros.propertyValidator('newTableName', ros.validateString)(properties.newTableName));
    return errors.wrap('supplied properties not correct for "TableIncludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.TableIncludes` resource
 *
 * @param properties - the TypeScript properties of a `TableIncludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob.TableIncludes` resource.
 */
// @ts-ignore TS6133
function rosMigrationJobTableIncludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob_TableIncludesPropertyValidator(properties).assertSuccess();
    return {
        TableName: ros.stringToRosTemplate(properties.tableName),
        FilterCondition: ros.stringToRosTemplate(properties.filterCondition),
        ColumnExcludes: ros.listMapper(rosMigrationJobColumnExcludesPropertyToRosTemplate)(properties.columnExcludes),
        ColumnIncludes: ros.listMapper(rosMigrationJobColumnIncludesPropertyToRosTemplate)(properties.columnIncludes),
        NewTableName: ros.stringToRosTemplate(properties.newTableName),
    };
}
/**
 * Determine whether the given properties match those of a `RosSynchronizationJobProps`
 *
 * @param properties - the TypeScript properties of a `RosSynchronizationJobProps`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJobPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('synchronizationObjects', ros.listValidator(RosSynchronizationJob_SynchronizationObjectsPropertyValidator))(properties.synchronizationObjects));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: ["Year", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateString)(properties.period));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Postpaid", "Prepaid"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('topology', ros.validateString)(properties.topology));
    errors.collect(ros.propertyValidator('sourceRegion', ros.requiredValidator)(properties.sourceRegion));
    errors.collect(ros.propertyValidator('sourceRegion', ros.validateString)(properties.sourceRegion));
    errors.collect(ros.propertyValidator('dataInitialization', ros.validateBoolean)(properties.dataInitialization));
    errors.collect(ros.propertyValidator('destinationEndpoint', ros.requiredValidator)(properties.destinationEndpoint));
    errors.collect(ros.propertyValidator('destinationEndpoint', RosSynchronizationJob_DestinationEndpointPropertyValidator)(properties.destinationEndpoint));
    if (properties.networkType && (typeof properties.networkType) !== 'object') {
        errors.collect(ros.propertyValidator('networkType', ros.validateAllowedValues)({
            data: properties.networkType,
            allowedValues: ["Internet", "Intranet"],
        }));
    }
    errors.collect(ros.propertyValidator('networkType', ros.validateString)(properties.networkType));
    errors.collect(ros.propertyValidator('sourceEndpoint', ros.requiredValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('sourceEndpoint', RosSynchronizationJob_SourceEndpointPropertyValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('usedTime', ros.validateNumber)(properties.usedTime));
    errors.collect(ros.propertyValidator('structureInitialization', ros.validateBoolean)(properties.structureInitialization));
    errors.collect(ros.propertyValidator('synchronizationJobClass', ros.requiredValidator)(properties.synchronizationJobClass));
    errors.collect(ros.propertyValidator('synchronizationJobClass', ros.validateString)(properties.synchronizationJobClass));
    errors.collect(ros.propertyValidator('destRegion', ros.requiredValidator)(properties.destRegion));
    errors.collect(ros.propertyValidator('destRegion', ros.validateString)(properties.destRegion));
    return errors.wrap('supplied properties not correct for "RosSynchronizationJobProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob` resource
 *
 * @param properties - the TypeScript properties of a `RosSynchronizationJobProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSynchronizationJobPropsValidator(properties).assertSuccess();
    }
    return {
        DestinationEndpoint: rosSynchronizationJobDestinationEndpointPropertyToRosTemplate(properties.destinationEndpoint),
        DestRegion: ros.stringToRosTemplate(properties.destRegion),
        SourceEndpoint: rosSynchronizationJobSourceEndpointPropertyToRosTemplate(properties.sourceEndpoint),
        SourceRegion: ros.stringToRosTemplate(properties.sourceRegion),
        SynchronizationJobClass: ros.stringToRosTemplate(properties.synchronizationJobClass),
        DataInitialization: ros.booleanToRosTemplate(properties.dataInitialization),
        NetworkType: ros.stringToRosTemplate(properties.networkType),
        PayType: ros.stringToRosTemplate(properties.payType),
        Period: ros.stringToRosTemplate(properties.period),
        StructureInitialization: ros.booleanToRosTemplate(properties.structureInitialization),
        SynchronizationObjects: ros.listMapper(rosSynchronizationJobSynchronizationObjectsPropertyToRosTemplate)(properties.synchronizationObjects),
        Topology: ros.stringToRosTemplate(properties.topology),
        UsedTime: ros.numberToRosTemplate(properties.usedTime),
    };
}
/**
 * A ROS template type:  `ALIYUN::DTS::SynchronizationJob`
 */
class RosSynchronizationJob extends ros.RosResource {
    /**
     * Create a new `ALIYUN::DTS::SynchronizationJob`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSynchronizationJob.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrSynchronizationJobId = ros.Token.asString(this.getAtt('SynchronizationJobId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.destinationEndpoint = props.destinationEndpoint;
        this.destRegion = props.destRegion;
        this.sourceEndpoint = props.sourceEndpoint;
        this.sourceRegion = props.sourceRegion;
        this.synchronizationJobClass = props.synchronizationJobClass;
        this.dataInitialization = props.dataInitialization;
        this.networkType = props.networkType;
        this.payType = props.payType;
        this.period = props.period;
        this.structureInitialization = props.structureInitialization;
        this.synchronizationObjects = props.synchronizationObjects;
        this.topology = props.topology;
        this.usedTime = props.usedTime;
    }
    get rosProperties() {
        return {
            destinationEndpoint: this.destinationEndpoint,
            destRegion: this.destRegion,
            sourceEndpoint: this.sourceEndpoint,
            sourceRegion: this.sourceRegion,
            synchronizationJobClass: this.synchronizationJobClass,
            dataInitialization: this.dataInitialization,
            networkType: this.networkType,
            payType: this.payType,
            period: this.period,
            structureInitialization: this.structureInitialization,
            synchronizationObjects: this.synchronizationObjects,
            topology: this.topology,
            usedTime: this.usedTime,
        };
    }
    renderProperties(props) {
        return rosSynchronizationJobPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSynchronizationJob = RosSynchronizationJob;
/**
 * The resource type name for this resource class.
 */
RosSynchronizationJob.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::SynchronizationJob";
/**
 * Determine whether the given properties match those of a `ColumnExcludesProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnExcludesProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_ColumnExcludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('columnName', ros.validateString)(properties.columnName));
    return errors.wrap('supplied properties not correct for "ColumnExcludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.ColumnExcludes` resource
 *
 * @param properties - the TypeScript properties of a `ColumnExcludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.ColumnExcludes` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobColumnExcludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_ColumnExcludesPropertyValidator(properties).assertSuccess();
    return {
        ColumnName: ros.stringToRosTemplate(properties.columnName),
    };
}
/**
 * Determine whether the given properties match those of a `ColumnIncludesProperty`
 *
 * @param properties - the TypeScript properties of a `ColumnIncludesProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_ColumnIncludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('newColumnName', ros.validateString)(properties.newColumnName));
    errors.collect(ros.propertyValidator('columnName', ros.validateString)(properties.columnName));
    return errors.wrap('supplied properties not correct for "ColumnIncludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.ColumnIncludes` resource
 *
 * @param properties - the TypeScript properties of a `ColumnIncludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.ColumnIncludes` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobColumnIncludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_ColumnIncludesPropertyValidator(properties).assertSuccess();
    return {
        NewColumnName: ros.stringToRosTemplate(properties.newColumnName),
        ColumnName: ros.stringToRosTemplate(properties.columnName),
    };
}
/**
 * Determine whether the given properties match those of a `DestinationEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_DestinationEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceTypeForCreation', ros.validateString)(properties.instanceTypeForCreation));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "DestinationEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.DestinationEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.DestinationEndpoint` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobDestinationEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_DestinationEndpointPropertyValidator(properties).assertSuccess();
    return {
        UserName: ros.stringToRosTemplate(properties.userName),
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        InstanceTypeForCreation: ros.stringToRosTemplate(properties.instanceTypeForCreation),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `SourceEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_SourceEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceTypeForCreation', ros.validateString)(properties.instanceTypeForCreation));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "SourceEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.SourceEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.SourceEndpoint` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobSourceEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_SourceEndpointPropertyValidator(properties).assertSuccess();
    return {
        Role: ros.stringToRosTemplate(properties.role),
        UserName: ros.stringToRosTemplate(properties.userName),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        InstanceTypeForCreation: ros.stringToRosTemplate(properties.instanceTypeForCreation),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `SynchronizationObjectsProperty`
 *
 * @param properties - the TypeScript properties of a `SynchronizationObjectsProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_SynchronizationObjectsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tableIncludes', ros.listValidator(RosSynchronizationJob_TableIncludesPropertyValidator))(properties.tableIncludes));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('tableExcludes', ros.listValidator(RosSynchronizationJob_TableExcludesPropertyValidator))(properties.tableExcludes));
    errors.collect(ros.propertyValidator('schemaName', ros.validateString)(properties.schemaName));
    errors.collect(ros.propertyValidator('newSchemaName', ros.validateString)(properties.newSchemaName));
    errors.collect(ros.propertyValidator('newDbName', ros.validateString)(properties.newDbName));
    return errors.wrap('supplied properties not correct for "SynchronizationObjectsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.SynchronizationObjects` resource
 *
 * @param properties - the TypeScript properties of a `SynchronizationObjectsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.SynchronizationObjects` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobSynchronizationObjectsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_SynchronizationObjectsPropertyValidator(properties).assertSuccess();
    return {
        TableIncludes: ros.listMapper(rosSynchronizationJobTableIncludesPropertyToRosTemplate)(properties.tableIncludes),
        DBName: ros.stringToRosTemplate(properties.dbName),
        TableExcludes: ros.listMapper(rosSynchronizationJobTableExcludesPropertyToRosTemplate)(properties.tableExcludes),
        SchemaName: ros.stringToRosTemplate(properties.schemaName),
        NewSchemaName: ros.stringToRosTemplate(properties.newSchemaName),
        NewDBName: ros.stringToRosTemplate(properties.newDbName),
    };
}
/**
 * Determine whether the given properties match those of a `TableExcludesProperty`
 *
 * @param properties - the TypeScript properties of a `TableExcludesProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_TableExcludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tableName', ros.validateString)(properties.tableName));
    return errors.wrap('supplied properties not correct for "TableExcludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.TableExcludes` resource
 *
 * @param properties - the TypeScript properties of a `TableExcludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.TableExcludes` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobTableExcludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_TableExcludesPropertyValidator(properties).assertSuccess();
    return {
        TableName: ros.stringToRosTemplate(properties.tableName),
    };
}
/**
 * Determine whether the given properties match those of a `TableIncludesProperty`
 *
 * @param properties - the TypeScript properties of a `TableIncludesProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob_TableIncludesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tableName', ros.validateString)(properties.tableName));
    errors.collect(ros.propertyValidator('filterCondition', ros.validateString)(properties.filterCondition));
    errors.collect(ros.propertyValidator('columnExcludes', ros.listValidator(RosSynchronizationJob_ColumnExcludesPropertyValidator))(properties.columnExcludes));
    errors.collect(ros.propertyValidator('columnIncludes', ros.listValidator(RosSynchronizationJob_ColumnIncludesPropertyValidator))(properties.columnIncludes));
    errors.collect(ros.propertyValidator('newTableName', ros.validateString)(properties.newTableName));
    return errors.wrap('supplied properties not correct for "TableIncludesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.TableIncludes` resource
 *
 * @param properties - the TypeScript properties of a `TableIncludesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob.TableIncludes` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJobTableIncludesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob_TableIncludesPropertyValidator(properties).assertSuccess();
    return {
        TableName: ros.stringToRosTemplate(properties.tableName),
        FilterCondition: ros.stringToRosTemplate(properties.filterCondition),
        ColumnExcludes: ros.listMapper(rosSynchronizationJobColumnExcludesPropertyToRosTemplate)(properties.columnExcludes),
        ColumnIncludes: ros.listMapper(rosSynchronizationJobColumnIncludesPropertyToRosTemplate)(properties.columnIncludes),
        NewTableName: ros.stringToRosTemplate(properties.newTableName),
    };
}
//# sourceMappingURL=data:application/json;base64,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