# 
#  Copyright (c) 2013-present, Anoop Kunchukuttan
#  All rights reserved.
#  
#  This source code is licensed under the MIT license found in the
#  LICENSE file in the root directory of this source tree.
# 

class SinhalaDevanagariTransliterator(object): 
    """
        A Devanagari to Sinhala transliterator based on explicit Unicode Mapping
    """

    sinhala_devnag_map={
                '\u0d82':'\u0902', 
                '\u0d83':'\u0903',
                '\u0d84':'\u0904',
                '\u0d85':'\u0905',
                '\u0d86':'\u0906',
                '\u0d87':'\u090d',
                '\u0d88':'\u090d',
                '\u0d89':'\u0907',
                '\u0d8a':'\u0908',
                '\u0d8b':'\u0909',
                '\u0d8c':'\u090a',
                '\u0d8d':'\u090b',
                '\u0d8f':'\u090c',
                '\u0d91':'\u090e',
                '\u0d92':'\u090f',
                '\u0d93':'\u0910',
                '\u0d94':'\u0912',
                '\u0d95':'\u0913',
                '\u0d96':'\u0914',
                '\u0d9a':'\u0915',
                '\u0d9b':'\u0916',
                '\u0d9c':'\u0917',
                '\u0d9d':'\u0918',
                '\u0d9e':'\u0919',
                '\u0d9f':'\u0919',
                '\u0da0':'\u091a',
                '\u0da1':'\u091b',
                '\u0da2':'\u091c',
                '\u0da3':'\u091d',
                '\u0da4':'\u091e',
                '\u0da5':'\u091e',
                '\u0da6':'\u091e',
                '\u0da7':'\u091f',
                '\u0da8':'\u0920',
                '\u0da9':'\u0921',
                '\u0daa':'\u0922',
                '\u0dab':'\u0923',
                '\u0dac':'\u0923',
                '\u0dad':'\u0924',
                '\u0dae':'\u0925',
                '\u0daf':'\u0926',
                '\u0db0':'\u0927',
                '\u0db1':'\u0928',
                '\u0db2':'\u0928',
                '\u0db3':'\u0928',
                '\u0db4':'\u092a',
                '\u0db5':'\u092b',
                '\u0db6':'\u092c',
                '\u0db7':'\u092d',
                '\u0db8':'\u092e',
                '\u0dba':'\u092f',
                '\u0dbb':'\u0930',
                '\u0dbd':'\u0932',
                '\u0dc5':'\u0933',
                '\u0dc0':'\u0935',
                '\u0dc1':'\u0936',
                '\u0dc2':'\u0937',
                '\u0dc3':'\u0938',
                '\u0dc4':'\u0939',
                '\u0dcf':'\u093e',
                '\u0dd0':'\u0949',
                '\u0dd1':'\u0949',
                '\u0dd2':'\u093f',
                '\u0dd3':'\u0940',
                '\u0dd4':'\u0941',
                '\u0dd6':'\u0942',
                '\u0dd8':'\u0943',
                '\u0dd9':'\u0946',
                '\u0dda':'\u0947',
                '\u0ddb':'\u0948',
                '\u0ddc':'\u094a',
                '\u0ddd':'\u094b',
                '\u0dde':'\u094c',
                '\u0dca':'\u094d',
            }

    devnag_sinhala_map={
            '\u0900':'\u0d82', 
            '\u0901':'\u0d82',
            '\u0902':'\u0d82',
            '\u0903':'\u0d83',
            '\u0904':'\u0d84',
            '\u0905':'\u0d85',
            '\u0906':'\u0d86',
            '\u0907':'\u0d89',
            '\u0908':'\u0d8a',
            '\u0909':'\u0d8b',
            '\u090a':'\u0d8c',
            '\u090b':'\u0d8d',
            '\u090c':'\u0d8f',
            '\u090d':'\u0d88',
            '\u090e':'\u0d91',
            '\u090f':'\u0d92',
            '\u0910':'\u0d93',
            '\u0912':'\u0d94',
            '\u0913':'\u0d95',
            '\u0914':'\u0d96',
            '\u0915':'\u0d9a',
            '\u0916':'\u0d9b',
            '\u0917':'\u0d9c',
            '\u0918':'\u0d9d',
            '\u0919':'\u0d9e',
            '\u091a':'\u0da0',
            '\u091b':'\u0da1',
            '\u091c':'\u0da2',
            '\u091d':'\u0da3',
            '\u091e':'\u0da4',
            '\u091f':'\u0da7',
            '\u0920':'\u0da8',
            '\u0921':'\u0da9',
            '\u0922':'\u0daa',
            '\u0923':'\u0dab',
            '\u0924':'\u0dad',
            '\u0925':'\u0dae',
            '\u0926':'\u0daf',
            '\u0927':'\u0db0',
            '\u0928':'\u0db1',
            '\u0929':'\u0db1',
            '\u092a':'\u0db4',
            '\u092b':'\u0db5',
            '\u092c':'\u0db6',
            '\u092d':'\u0db7',
            '\u092e':'\u0db8',
            '\u092f':'\u0dba',
            '\u0930':'\u0dbb',
            '\u0932':'\u0dbd',
            '\u0933':'\u0dc5',
            '\u0935':'\u0dc0',
            '\u0936':'\u0dc1',
            '\u0937':'\u0dc2',
            '\u0938':'\u0dc3',
            '\u0939':'\u0dc4',
            '\u093e':'\u0dcf',
            '\u0949':'\u0dd1',
            '\u093f':'\u0dd2',
            '\u0940':'\u0dd3',
            '\u0941':'\u0dd4',
            '\u0942':'\u0dd6',
            '\u0943':'\u0dd8',
            '\u0946':'\u0dd9',
            '\u0947':'\u0dda',
            '\u0948':'\u0ddb',
            '\u094a':'\u0ddc',
            '\u094b':'\u0ddd',
            '\u094c':'\u0dde',
            '\u094d':'\u0dca',
            
        }

    @staticmethod
    def devanagari_to_sinhala(text):
        return ''.join([ SinhalaDevanagariTransliterator.devnag_sinhala_map.get(c,c) for c in text ])

    @staticmethod
    def sinhala_to_devanagari(text):
        return ''.join([ SinhalaDevanagariTransliterator.sinhala_devnag_map.get(c,c) for c in text ])

