from cbsyst.helpers import Bunch

boron_ref = Bunch(
            {
                "ABO3": 0.80882747,
                "ABO4": 0.80464341,
                "ABT": 0.80781778,
                "BO3": 328.50895695,
                "BO4": 104.49104305,
                "BT": 433.0,
                "H": 7.94328235e-09,
                "Ks": Bunch({
                    'K0': 0.028391881804015685,
                    'K1': 1.4218281371391736e-06,
                    'K2': 1.0815547472209423e-09,
                    'KW': 6.063863686105376e-14,
                    'KB': 2.5265729902477677e-09,
                    'KS': 0.10030207107256615,
                    'KspA': 6.481759068011968e-07,
                    'KspC': 4.272350927862591e-07,
                    'KP1': 0.024442701952839218,
                    'KP2': 1.0920346472024867e-06,
                    'KP3': 1.624298741811419e-09,
                    'KSi': 4.132522892193706e-10,
                    'KF': 0.0022610979159034443}
                ),
                "Mg": 0.0528171,
                "Ca": 0.0102821,
                "S_in": 35.0,
                "T_in": 25.0,
                "alphaB": 1.0272,
                "dBO3": 46.29633251,
                "dBO4": 18.59066638,
                "dBT": 39.5,
                "pHtot": 8.1,
            }
        )

carbon_ref = Bunch(
            {
                "BAlk": 104.39451552567037,
                "BT": 432.6,
                "CAlk": 2340.16132518,
                "CO2": 10.27549047,
                "CO3": 250.43681565,
                "Ca": 0.0102821,
                "DIC": 2100.0,
                "H": 7.94328235e-09,
                "HCO3": 1839.28769389,
                "HF": 0.00017903616862286758,
                "HSO4": 0.0017448760289520083,
                "Hfree": 0.0061984062104620289,
                "Ks": Bunch({
                    "K0": 0.028391881804015699,
                    "K1": 1.4218281371391736e-06,
                    "K2": 1.0815547472209423e-09,
                    "KB": 2.5265729902477677e-09,
                    "KF": 0.0023655007956108367,
                    "KP1": 0.024265183950721327,
                    "KP2": 1.0841036169428488e-06,
                    "KP3": 1.612502080867568e-09,
                    "KS": 0.10030207107256615,
                    "KSi": 4.1025099579058308e-10,
                    "KW": 6.019824161802715e-14,
                    "KspA": 6.4817590680119676e-07,
                    "KspC": 4.2723509278625912e-07,
                }),
                "Mg": 0.0528171,
                "OH": 7.57850961,
                "P": None,
                "PAlk": 0.0,
                "S": 35.0,
                "SiAlk": 0.0,
                "T": 25.0,
                "TA": 2452.126228,
                "TF": 6.832583968836728e-05,
                "TP": 0.0,
                "TS": 0.028235434132860126,
                "TSi": 0.0,
                "fCO2": 361.91649919340324,
                "pCO2": 363.074540437976,
                "pHtot": 8.1,
                "unit": 1000000.0,
            }
        )
