import * as cdk from '@aws-cdk/core';
import { CfnVirtualGateway, CfnVirtualNode } from './appmesh.generated';
import { ClientPolicy } from './client-policy';
import { IVirtualService } from './virtual-service';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) Represents timeouts for HTTP protocols.
 *
 * @experimental
 */
export interface HttpTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
    /**
     * (experimental) Represents per request timeout.
     *
     * @default - 15 s
     * @experimental
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * (experimental) Represents timeouts for GRPC protocols.
 *
 * @experimental
 */
export interface GrpcTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
    /**
     * (experimental) Represents per request timeout.
     *
     * @default - 15 s
     * @experimental
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * (experimental) Represents timeouts for TCP protocols.
 *
 * @experimental
 */
export interface TcpTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
}
/**
 * (experimental) Enum of supported AppMesh protocols.
 *
 * @experimental
 */
export declare enum Protocol {
    /**
     * @experimental
     */
    HTTP = "http",
    /**
     * @experimental
     */
    TCP = "tcp",
    /**
     * @experimental
     */
    HTTP2 = "http2",
    /**
     * @experimental
     */
    GRPC = "grpc"
}
/**
 * (experimental) Properties used to define healthchecks when creating virtual nodes.
 *
 * All values have a default if only specified as {} when creating.
 * If property not set, then no healthchecks will be defined.
 *
 * @experimental
 */
export interface HealthCheck {
    /**
     * (experimental) Number of successful attempts before considering the node UP.
     *
     * @default 2
     * @experimental
     */
    readonly healthyThreshold?: number;
    /**
     * (experimental) Interval in milliseconds to re-check.
     *
     * @default 5 seconds
     * @experimental
     */
    readonly interval?: cdk.Duration;
    /**
     * (experimental) The path where the application expects any health-checks, this can also be the application path.
     *
     * @default /
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The TCP port number for the healthcheck.
     *
     * @default - same as corresponding port mapping
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The protocol to use for the healthcheck, for convinience a const enum has been defined.
     *
     * Protocol.HTTP or Protocol.TCP
     *
     * @default - same as corresponding port mapping
     * @experimental
     */
    readonly protocol?: Protocol;
    /**
     * (experimental) Timeout in milli-seconds for the healthcheck to be considered a fail.
     *
     * @default 2 seconds
     * @experimental
     */
    readonly timeout?: cdk.Duration;
    /**
     * (experimental) Number of failed attempts before considering the node DOWN.
     *
     * @default 2
     * @experimental
     */
    readonly unhealthyThreshold?: number;
}
/**
 * (experimental) All Properties for Envoy Access logs for mesh endpoints.
 *
 * @experimental
 */
export interface AccessLogConfig {
    /**
     * (experimental) VirtualNode CFN configuration for Access Logging.
     *
     * @default - no access logging
     * @experimental
     */
    readonly virtualNodeAccessLog?: CfnVirtualNode.AccessLogProperty;
    /**
     * (experimental) VirtualGateway CFN configuration for Access Logging.
     *
     * @default - no access logging
     * @experimental
     */
    readonly virtualGatewayAccessLog?: CfnVirtualGateway.VirtualGatewayAccessLogProperty;
}
/**
 * (experimental) Configuration for Envoy Access logs for mesh endpoints.
 *
 * @experimental
 */
export declare abstract class AccessLog {
    /**
     * (experimental) Path to a file to write access logs to.
     *
     * @default - no file based access logging
     * @experimental
     */
    static fromFilePath(filePath: string): AccessLog;
    /**
     * (experimental) Called when the AccessLog type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @experimental
     */
    abstract bind(scope: Construct): AccessLogConfig;
}
/**
 * (experimental) Represents the properties needed to define backend defaults.
 *
 * @experimental
 */
export interface BackendDefaults {
    /**
     * (experimental) Client policy for backend defaults.
     *
     * @default none
     * @experimental
     */
    readonly clientPolicy?: ClientPolicy;
}
/**
 * (experimental) Represents the properties needed to define a Virtual Service backend.
 *
 * @experimental
 */
export interface VirtualServiceBackendOptions {
    /**
     * (experimental) Client policy for the backend.
     *
     * @default none
     * @experimental
     */
    readonly clientPolicy?: ClientPolicy;
}
/**
 * (experimental) Properties for a backend.
 *
 * @experimental
 */
export interface BackendConfig {
    /**
     * (experimental) Config for a Virtual Service backend.
     *
     * @experimental
     */
    readonly virtualServiceBackend: CfnVirtualNode.BackendProperty;
}
/**
 * (experimental) Contains static factory methods to create backends.
 *
 * @experimental
 */
export declare abstract class Backend {
    /**
     * (experimental) Construct a Virtual Service backend.
     *
     * @experimental
     */
    static virtualService(virtualService: IVirtualService, props?: VirtualServiceBackendOptions): Backend;
    /**
     * (experimental) Return backend config.
     *
     * @experimental
     */
    abstract bind(_scope: Construct): BackendConfig;
}
