/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.utils;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FreemarkerUtils {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtils.class);
    private static final String TEMPLATES = "templates";

    private FreemarkerUtils() {
    }

    public static String processTemplate(String path, Object object) {
        return FreemarkerUtils.processTemplate(path, "en", "0.###", object);
    }

    private static String proccessTemplate(Configuration configuration, String locale, String templateName, Object object) {
        Map<String, String> messages = FreemarkerUtils.readMessages(locale);
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("data", object);
            data.put("messages", messages);
            StringWriter writer = new StringWriter();
            Template template = configuration.getTemplate(templateName);
            template.process(data, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String processTemplate(String path, String locale, String numberFormat, Object object) {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setClassForTemplateLoading(FreemarkerUtils.class, "/");
        configuration.setDefaultEncoding("UTF-8");
        configuration.setNumberFormat(numberFormat);
        return FreemarkerUtils.proccessTemplate(configuration, locale, path, object);
    }

    public static String processCustomTemplate(String customTemplatePath, String locale, String numberFormat, Object object) throws IOException {
        File template = new File(customTemplatePath);
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(template.getParentFile()));
        configuration.setDefaultEncoding("UTF-8");
        configuration.setNumberFormat(numberFormat);
        return FreemarkerUtils.proccessTemplate(configuration, locale, template.getName(), object);
    }

    public static Map<String, String> readMessages(String localeCode) {
        Properties properties = new Properties();
        HashMap<String, String> mymap = new HashMap<String, String>();
        String resourceName = "message." + localeCode;
        log.info("read locale from " + resourceName);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream resourceStream = loader.getResourceAsStream(resourceName);){
            InputStreamReader isr = new InputStreamReader(resourceStream, StandardCharsets.UTF_8);
            properties.load(isr);
        }
        catch (Exception e) {
            log.error("can't read locale resource" + e);
        }
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            mymap.put(key, value);
        }
        return mymap;
    }
}

