/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.writer;

import com.github.viclovsky.swagger.coverage.SwaggerCoverageWriteException;
import com.github.viclovsky.swagger.coverage.configuration.options.ResultsWriterOptions;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.writer.CoverageResultsWriter;
import com.github.viclovsky.swagger.coverage.utils.FreemarkerUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportResultsWriter
implements CoverageResultsWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReportResultsWriter.class);
    private ResultsWriterOptions options;
    private String filename = "swagger-coverage-report.html";
    private String localeCode = "en";
    private String numberFormat = "0.###";

    public HtmlReportResultsWriter() {
        this.options = new ResultsWriterOptions().setFilename(this.filename).setLocale(this.localeCode).setNumberFormat(this.numberFormat);
    }

    public HtmlReportResultsWriter(ResultsWriterOptions options) {
        if (options.getLocale() == null) {
            options.setLocale(this.localeCode);
        }
        if (options.getFilename() == null) {
            options.setFilename(this.filename);
        }
        if (options.getNumberFormat() == null) {
            options.setNumberFormat(this.numberFormat);
        }
        this.options = options;
    }

    @Override
    public void write(Results results) {
        Path path = Paths.get(this.options.getFilename(), new String[0]);
        LOGGER.info(String.format("Write html report in file '%s'", path.toAbsolutePath()));
        try {
            String htmlReport = this.options.getCustomTemplatePath() == null ? FreemarkerUtils.processTemplate((String)"report.ftl", (String)this.options.getLocale(), (String)this.options.getNumberFormat(), (Object)results) : FreemarkerUtils.processCustomTemplate((String)this.options.getCustomTemplatePath(), (String)this.options.getLocale(), (String)this.options.getNumberFormat(), (Object)results);
            Files.write(Paths.get(this.options.getFilename(), new String[0]), htmlReport.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SwaggerCoverageWriteException("Could not write results", (Throwable)e);
        }
    }
}

