/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.viclovsky.swagger.coverage.SwaggerCoverageWriteException;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.writer.CoverageResultsWriter;
import com.github.viclovsky.swagger.coverage.model.SwaggerCoverage2ModelJackson;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemResultsWriter
implements CoverageResultsWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemResultsWriter.class);
    private final ObjectMapper mapper;
    private final String fileName;

    public FileSystemResultsWriter() {
        this("swagger-coverage-results.json");
    }

    public FileSystemResultsWriter(String fileName) {
        this.fileName = fileName;
        this.mapper = SwaggerCoverage2ModelJackson.createJsonMapper();
    }

    @Override
    public void write(Results results) {
        String swaggerResultName = this.fileName;
        Path path = Paths.get(swaggerResultName, new String[0]);
        LOGGER.info(String.format("Write results in file '%s'", path.toAbsolutePath()));
        try (OutputStream os = Files.newOutputStream(Paths.get(swaggerResultName, new String[0]), new OpenOption[0]);){
            this.mapper.writeValue(os, (Object)results);
        }
        catch (IOException e) {
            throw new SwaggerCoverageWriteException("Could not write results", (Throwable)e);
        }
    }
}

