/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.results.builder.postbuilder;

import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.model.OperationKey;
import com.github.viclovsky.swagger.coverage.core.model.OperationsHolder;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.results.builder.core.StatisticsOperationPostBuilder;
import com.github.viclovsky.swagger.coverage.core.results.data.CoverageCounter;
import com.github.viclovsky.swagger.coverage.core.results.data.OperationResult;
import com.github.viclovsky.swagger.coverage.core.results.data.TagCoverage;
import com.github.viclovsky.swagger.coverage.core.rule.core.ConditionRule;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagStatisticsBuilder
extends StatisticsOperationPostBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagStatisticsBuilder.class);
    private Map<OperationKey, List<String>> operationToTag;
    private Map<String, TagCoverage> tagCoverageMap;
    private CoverageCounter tagCounter = new CoverageCounter();

    @Override
    public TagStatisticsBuilder configure(OpenAPI swagger, List<ConditionRule> rules) {
        OperationsHolder operations = SwaggerSpecificationProcessor.extractOperation(swagger);
        this.tagCoverageMap = Optional.ofNullable(swagger.getTags()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(Tag::getName, TagCoverage::new));
        this.operationToTag = operations.getOperations().entrySet().stream().filter(entry -> ((Operation)entry.getValue()).getTags() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Operation)entry.getValue()).getTags()));
        this.operationToTag.forEach((key, value) -> value.stream().filter(tag -> this.tagCoverageMap.containsKey(tag)).forEach(tag -> this.tagCoverageMap.get(tag).addOperation((OperationKey)key)));
        return this;
    }

    @Override
    public void buildOperation(OperationKey operation, OperationResult operationResult) {
        this.operationToTag.forEach((key, value) -> {
            if (operation.toString().equals(key.toString())) {
                value.stream().filter(tag -> this.tagCoverageMap.containsKey(tag)).forEach(tag -> this.tagCoverageMap.get(tag).updateCallCount(operationResult.getProcessCount()).incrementByState(operationResult.getState()).updateAllConditionCount(operationResult.getAllConditionCount()).updateCoveredConditionCount(operationResult.getCoveredConditionCount()).updateState());
            }
        });
    }

    @Override
    public void buildResult(Results results) {
        LOGGER.info(this.tagCoverageMap.toString());
        this.tagCoverageMap.forEach((key, value) -> this.tagCounter.incrementByState(value.getState()));
        results.setTagCoverageMap(this.tagCoverageMap).setTagCounter(this.tagCounter);
    }
}

