/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.results.builder.postbuilder;

import com.github.viclovsky.swagger.coverage.core.model.OperationKey;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.results.builder.core.StatisticsOperationPostBuilder;
import com.github.viclovsky.swagger.coverage.core.results.data.ConditionCounter;
import com.github.viclovsky.swagger.coverage.core.results.data.CoverageOperationMap;
import com.github.viclovsky.swagger.coverage.core.results.data.CoverageState;
import com.github.viclovsky.swagger.coverage.core.results.data.OperationResult;

public class ConditionStatisticsBuilder
extends StatisticsOperationPostBuilder {
    private CoverageOperationMap coverageOperationMap = new CoverageOperationMap();
    private ConditionCounter conditionCounter = new ConditionCounter();

    @Override
    public void buildResult(Results results) {
        results.setCoverageOperationMap(this.coverageOperationMap).setConditionCounter(this.conditionCounter);
    }

    @Override
    public void buildOperation(OperationKey operation, OperationResult operationResult) {
        this.conditionCounter.updateAll(operationResult.getAllConditionCount());
        this.conditionCounter.updateCovered(operationResult.getCoveredConditionCount());
        switch (operationResult.getState()) {
            case PARTY: {
                this.coverageOperationMap.addParty(operation);
                break;
            }
            case EMPTY: {
                this.coverageOperationMap.addEmpty(operation);
                break;
            }
            case FULL: {
                this.coverageOperationMap.addFull(operation);
            }
        }
        if (operationResult.getDeprecated()) {
            this.coverageOperationMap.addDeprecated(operation);
            this.conditionCounter.incrementDeprecated();
            if (operationResult.getState() == CoverageState.EMPTY) {
                this.conditionCounter.incrementDeprecatedAndEmpty();
            }
        }
    }
}

