"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterNodePool = exports.ClusterNodePoolProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cs_generated_1 = require("./cs.generated");
Object.defineProperty(exports, "ClusterNodePoolProperty", { enumerable: true, get: function () { return cs_generated_1.RosClusterNodePool; } });
/**
 * A ROS resource type:  `ALIYUN::CS::ClusterNodePool`
 */
class ClusterNodePool extends ros.Resource {
    /**
     * Create a new `ALIYUN::CS::ClusterNodePool`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosClusterNodePool = new cs_generated_1.RosClusterNodePool(this, id, {
            teeConfig: props.teeConfig,
            clusterId: props.clusterId,
            nodePoolInfo: props.nodePoolInfo,
            kubernetesConfig: props.kubernetesConfig,
            count: props.count,
            management: props.management,
            autoScaling: props.autoScaling,
            scalingGroup: props.scalingGroup,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosClusterNodePool;
        this.attrNodePoolId = rosClusterNodePool.attrNodePoolId;
    }
}
exports.ClusterNodePool = ClusterNodePool;
//# sourceMappingURL=data:application/json;base64,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