# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/filecoin-project/bacalhau.  # noqa: E501

    OpenAPI spec version: 0.3.18-rev2
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from bacalhau_apiclient.configuration import Configuration


class RunCommandResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'exit_code': 'int',
        'runner_error': 'str',
        'stderr': 'str',
        'stderrtruncated': 'bool',
        'stdout': 'str',
        'stdouttruncated': 'bool'
    }

    attribute_map = {
        'exit_code': 'exitCode',
        'runner_error': 'runnerError',
        'stderr': 'stderr',
        'stderrtruncated': 'stderrtruncated',
        'stdout': 'stdout',
        'stdouttruncated': 'stdouttruncated'
    }

    def __init__(self, exit_code=None, runner_error=None, stderr=None, stderrtruncated=None, stdout=None, stdouttruncated=None, _configuration=None):  # noqa: E501
        """RunCommandResult - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._exit_code = None
        self._runner_error = None
        self._stderr = None
        self._stderrtruncated = None
        self._stdout = None
        self._stdouttruncated = None
        self.discriminator = None

        if exit_code is not None:
            self.exit_code = exit_code
        if runner_error is not None:
            self.runner_error = runner_error
        if stderr is not None:
            self.stderr = stderr
        if stderrtruncated is not None:
            self.stderrtruncated = stderrtruncated
        if stdout is not None:
            self.stdout = stdout
        if stdouttruncated is not None:
            self.stdouttruncated = stdouttruncated

    @property
    def exit_code(self):
        """Gets the exit_code of this RunCommandResult.  # noqa: E501

        exit code of the run.  # noqa: E501

        :return: The exit_code of this RunCommandResult.  # noqa: E501
        :rtype: int
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code):
        """Sets the exit_code of this RunCommandResult.

        exit code of the run.  # noqa: E501

        :param exit_code: The exit_code of this RunCommandResult.  # noqa: E501
        :type: int
        """

        self._exit_code = exit_code

    @property
    def runner_error(self):
        """Gets the runner_error of this RunCommandResult.  # noqa: E501

        Runner error  # noqa: E501

        :return: The runner_error of this RunCommandResult.  # noqa: E501
        :rtype: str
        """
        return self._runner_error

    @runner_error.setter
    def runner_error(self, runner_error):
        """Sets the runner_error of this RunCommandResult.

        Runner error  # noqa: E501

        :param runner_error: The runner_error of this RunCommandResult.  # noqa: E501
        :type: str
        """

        self._runner_error = runner_error

    @property
    def stderr(self):
        """Gets the stderr of this RunCommandResult.  # noqa: E501

        stderr of the run.  # noqa: E501

        :return: The stderr of this RunCommandResult.  # noqa: E501
        :rtype: str
        """
        return self._stderr

    @stderr.setter
    def stderr(self, stderr):
        """Sets the stderr of this RunCommandResult.

        stderr of the run.  # noqa: E501

        :param stderr: The stderr of this RunCommandResult.  # noqa: E501
        :type: str
        """

        self._stderr = stderr

    @property
    def stderrtruncated(self):
        """Gets the stderrtruncated of this RunCommandResult.  # noqa: E501

        bool describing if stderr was truncated  # noqa: E501

        :return: The stderrtruncated of this RunCommandResult.  # noqa: E501
        :rtype: bool
        """
        return self._stderrtruncated

    @stderrtruncated.setter
    def stderrtruncated(self, stderrtruncated):
        """Sets the stderrtruncated of this RunCommandResult.

        bool describing if stderr was truncated  # noqa: E501

        :param stderrtruncated: The stderrtruncated of this RunCommandResult.  # noqa: E501
        :type: bool
        """

        self._stderrtruncated = stderrtruncated

    @property
    def stdout(self):
        """Gets the stdout of this RunCommandResult.  # noqa: E501

        stdout of the run. Yaml provided for `describe` output  # noqa: E501

        :return: The stdout of this RunCommandResult.  # noqa: E501
        :rtype: str
        """
        return self._stdout

    @stdout.setter
    def stdout(self, stdout):
        """Sets the stdout of this RunCommandResult.

        stdout of the run. Yaml provided for `describe` output  # noqa: E501

        :param stdout: The stdout of this RunCommandResult.  # noqa: E501
        :type: str
        """

        self._stdout = stdout

    @property
    def stdouttruncated(self):
        """Gets the stdouttruncated of this RunCommandResult.  # noqa: E501

        bool describing if stdout was truncated  # noqa: E501

        :return: The stdouttruncated of this RunCommandResult.  # noqa: E501
        :rtype: bool
        """
        return self._stdouttruncated

    @stdouttruncated.setter
    def stdouttruncated(self, stdouttruncated):
        """Sets the stdouttruncated of this RunCommandResult.

        bool describing if stdout was truncated  # noqa: E501

        :param stdouttruncated: The stdouttruncated of this RunCommandResult.  # noqa: E501
        :type: bool
        """

        self._stdouttruncated = stdouttruncated

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RunCommandResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RunCommandResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RunCommandResult):
            return True

        return self.to_dict() != other.to_dict()
