# BrowserUpMitmProxyClient
___
This is the REST API for controlling the BrowserUp MitmProxy.
The BrowserUp MitmProxy is a swiss army knife for automated testing that
captures HTTP traffic in HAR files. It is also useful for Selenium/Cypress tests.
___


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import BrowserUpMitmProxyClient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import BrowserUpMitmProxyClient
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import BrowserUpMitmProxyClient
from pprint import pprint
from BrowserUpMitmProxyClient.api import browser_up_proxy_api
from BrowserUpMitmProxyClient.model.counter import Counter
from BrowserUpMitmProxyClient.model.error import Error
from BrowserUpMitmProxyClient.model.har import Har
from BrowserUpMitmProxyClient.model.match_criteria import MatchCriteria
from BrowserUpMitmProxyClient.model.verify_result import VerifyResult
# Defining the host is optional and defaults to http://localhost:8088
# See configuration.py for a list of all supported configuration parameters.
configuration = BrowserUpMitmProxyClient.Configuration(
    host = "http://localhost:8088"
)



# Enter a context with an instance of the API client
with BrowserUpMitmProxyClient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = browser_up_proxy_api.BrowserUpProxyApi(api_client)
    counter = Counter(
        value=3.14,
        name="name_example",
    ) # Counter | Receives a new counter to add. The counter is stored, under the hood, in an array in the har under the _counters key

    try:
        api_instance.add_counter(counter)
    except BrowserUpMitmProxyClient.ApiException as e:
        print("Exception when calling BrowserUpProxyApi->add_counter: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8088*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BrowserUpProxyApi* | [**add_counter**](docs/BrowserUpProxyApi.md#add_counter) | **POST** /har/counters | 
*BrowserUpProxyApi* | [**add_error**](docs/BrowserUpProxyApi.md#add_error) | **POST** /har/errors | 
*BrowserUpProxyApi* | [**get_har_log**](docs/BrowserUpProxyApi.md#get_har_log) | **GET** /har | 
*BrowserUpProxyApi* | [**healthcheck**](docs/BrowserUpProxyApi.md#healthcheck) | **GET** /healthcheck | 
*BrowserUpProxyApi* | [**new_page**](docs/BrowserUpProxyApi.md#new_page) | **POST** /har/page | 
*BrowserUpProxyApi* | [**reset_har_log**](docs/BrowserUpProxyApi.md#reset_har_log) | **PUT** /har | 
*BrowserUpProxyApi* | [**verify_not_present**](docs/BrowserUpProxyApi.md#verify_not_present) | **POST** /verify/not_present/{name} | 
*BrowserUpProxyApi* | [**verify_present**](docs/BrowserUpProxyApi.md#verify_present) | **POST** /verify/present/{name} | 
*BrowserUpProxyApi* | [**verify_size**](docs/BrowserUpProxyApi.md#verify_size) | **POST** /verify/size/{size}/{name} | 
*BrowserUpProxyApi* | [**verify_sla**](docs/BrowserUpProxyApi.md#verify_sla) | **POST** /verify/sla/{time}/{name} | 


## Documentation For Models

 - [Counter](docs/Counter.md)
 - [CustomHarData](docs/CustomHarData.md)
 - [Entry](docs/Entry.md)
 - [EntryRequest](docs/EntryRequest.md)
 - [EntryRequestCookies](docs/EntryRequestCookies.md)
 - [EntryRequestQueryString](docs/EntryRequestQueryString.md)
 - [EntryResponse](docs/EntryResponse.md)
 - [EntryResponseContent](docs/EntryResponseContent.md)
 - [EntryTimings](docs/EntryTimings.md)
 - [Error](docs/Error.md)
 - [Har](docs/Har.md)
 - [HarLog](docs/HarLog.md)
 - [HarLogCreator](docs/HarLogCreator.md)
 - [Header](docs/Header.md)
 - [MatchCriteria](docs/MatchCriteria.md)
 - [NameValuePair](docs/NameValuePair.md)
 - [Page](docs/Page.md)
 - [PagePageTimings](docs/PagePageTimings.md)
 - [VerifyResult](docs/VerifyResult.md)
 - [WebSocketMessage](docs/WebSocketMessage.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

developers@browserup.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in BrowserUpMitmProxyClient.apis and BrowserUpMitmProxyClient.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from BrowserUpMitmProxyClient.api.default_api import DefaultApi`
- `from BrowserUpMitmProxyClient.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import BrowserUpMitmProxyClient
from BrowserUpMitmProxyClient.apis import *
from BrowserUpMitmProxyClient.models import *
```

