"""
    BrowserUp MitmProxy

    ___ This is the REST API for controlling the BrowserUp MitmProxy. The BrowserUp MitmProxy is a swiss army knife for automated testing that captures HTTP traffic in HAR files. It is also useful for Selenium/Cypress tests. ___   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: developers@browserup.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from BrowserUpMitmProxyClient.api_client import ApiClient, Endpoint as _Endpoint
from BrowserUpMitmProxyClient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from BrowserUpMitmProxyClient.model.counter import Counter
from BrowserUpMitmProxyClient.model.error import Error
from BrowserUpMitmProxyClient.model.har import Har
from BrowserUpMitmProxyClient.model.match_criteria import MatchCriteria
from BrowserUpMitmProxyClient.model.verify_result import VerifyResult


class BrowserUpProxyApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_counter(
            self,
            counter,
            **kwargs
        ):
            """add_counter  # noqa: E501

            Add Custom Counter to the captured traffic har  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_counter(counter, async_req=True)
            >>> result = thread.get()

            Args:
                counter (Counter): Receives a new counter to add. The counter is stored, under the hood, in an array in the har under the _counters key

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['counter'] = \
                counter
            return self.call_with_http_info(**kwargs)

        self.add_counter = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/har/counters',
                'operation_id': 'add_counter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'counter',
                ],
                'required': [
                    'counter',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'counter':
                        (Counter,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'counter': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_counter
        )

        def __add_error(
            self,
            error,
            **kwargs
        ):
            """add_error  # noqa: E501

            Add Custom Error to the captured traffic har  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_error(error, async_req=True)
            >>> result = thread.get()

            Args:
                error (Error): Receives an error to track. Internally, the error is stored in an array in the har under the _errors key

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['error'] = \
                error
            return self.call_with_http_info(**kwargs)

        self.add_error = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/har/errors',
                'operation_id': 'add_error',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'error',
                ],
                'required': [
                    'error',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'error':
                        (Error,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'error': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_error
        )

        def __get_har_log(
            self,
            **kwargs
        ):
            """get_har_log  # noqa: E501

            Get the current HAR.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_har_log(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Har
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_har_log = _Endpoint(
            settings={
                'response_type': (Har,),
                'auth': [],
                'endpoint_path': '/har',
                'operation_id': 'get_har_log',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_har_log
        )

        def __healthcheck(
            self,
            **kwargs
        ):
            """healthcheck  # noqa: E501

            Get the healthcheck  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.healthcheck(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.healthcheck = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/healthcheck',
                'operation_id': 'healthcheck',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__healthcheck
        )

        def __new_page(
            self,
            title,
            **kwargs
        ):
            """new_page  # noqa: E501

            Starts a fresh HAR Page (Step) in the current active HAR to group requests.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.new_page(title, async_req=True)
            >>> result = thread.get()

            Args:
                title (str): The unique title for this har page/step.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Har
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['title'] = \
                title
            return self.call_with_http_info(**kwargs)

        self.new_page = _Endpoint(
            settings={
                'response_type': (Har,),
                'auth': [],
                'endpoint_path': '/har/page',
                'operation_id': 'new_page',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'title',
                ],
                'required': [
                    'title',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'title',
                ]
            },
            root_map={
                'validations': {
                    ('title',): {

                        'regex': {
                            'pattern': r'[a-zA-Z-_]{4,25}',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'title':
                        (str,),
                },
                'attribute_map': {
                    'title': 'title',
                },
                'location_map': {
                    'title': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__new_page
        )

        def __reset_har_log(
            self,
            **kwargs
        ):
            """reset_har_log  # noqa: E501

            Starts a fresh HAR capture session.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_har_log(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Har
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.reset_har_log = _Endpoint(
            settings={
                'response_type': (Har,),
                'auth': [],
                'endpoint_path': '/har',
                'operation_id': 'reset_har_log',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__reset_har_log
        )

        def __verify_not_present(
            self,
            name,
            match_criteria,
            **kwargs
        ):
            """verify_not_present  # noqa: E501

            Verify no matching items are present in the captured traffic  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_not_present(name, match_criteria, async_req=True)
            >>> result = thread.get()

            Args:
                name (str): The unique name for this verification operation
                match_criteria (MatchCriteria): Match criteria to select requests - response pairs for size tests

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VerifyResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['match_criteria'] = \
                match_criteria
            return self.call_with_http_info(**kwargs)

        self.verify_not_present = _Endpoint(
            settings={
                'response_type': (VerifyResult,),
                'auth': [],
                'endpoint_path': '/verify/not_present/{name}',
                'operation_id': 'verify_not_present',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'match_criteria',
                ],
                'required': [
                    'name',
                    'match_criteria',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'[a-zA-Z-_]{4,25}',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'match_criteria':
                        (MatchCriteria,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                    'match_criteria': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_not_present
        )

        def __verify_present(
            self,
            name,
            match_criteria,
            **kwargs
        ):
            """verify_present  # noqa: E501

            Verify at least one matching item is present in the captured traffic  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_present(name, match_criteria, async_req=True)
            >>> result = thread.get()

            Args:
                name (str): The unique name for this verification operation
                match_criteria (MatchCriteria): Match criteria to select requests - response pairs for size tests

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VerifyResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['match_criteria'] = \
                match_criteria
            return self.call_with_http_info(**kwargs)

        self.verify_present = _Endpoint(
            settings={
                'response_type': (VerifyResult,),
                'auth': [],
                'endpoint_path': '/verify/present/{name}',
                'operation_id': 'verify_present',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'match_criteria',
                ],
                'required': [
                    'name',
                    'match_criteria',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'[a-zA-Z-_]{4,25}',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'match_criteria':
                        (MatchCriteria,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                    'match_criteria': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_present
        )

        def __verify_size(
            self,
            size,
            name,
            match_criteria,
            **kwargs
        ):
            """verify_size  # noqa: E501

            Verify matching items in the captured traffic meet the size criteria  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_size(size, name, match_criteria, async_req=True)
            >>> result = thread.get()

            Args:
                size (int): The size used for comparison, in kilobytes
                name (str): The unique name for this verification operation
                match_criteria (MatchCriteria): Match criteria to select requests - response pairs for size tests

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VerifyResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['size'] = \
                size
            kwargs['name'] = \
                name
            kwargs['match_criteria'] = \
                match_criteria
            return self.call_with_http_info(**kwargs)

        self.verify_size = _Endpoint(
            settings={
                'response_type': (VerifyResult,),
                'auth': [],
                'endpoint_path': '/verify/size/{size}/{name}',
                'operation_id': 'verify_size',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'size',
                    'name',
                    'match_criteria',
                ],
                'required': [
                    'size',
                    'name',
                    'match_criteria',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'size',
                    'name',
                ]
            },
            root_map={
                'validations': {
                    ('size',): {

                        'inclusive_minimum': 0,
                    },
                    ('name',): {

                        'regex': {
                            'pattern': r'[a-zA-Z-_]{4,25}',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'size':
                        (int,),
                    'name':
                        (str,),
                    'match_criteria':
                        (MatchCriteria,),
                },
                'attribute_map': {
                    'size': 'size',
                    'name': 'name',
                },
                'location_map': {
                    'size': 'path',
                    'name': 'path',
                    'match_criteria': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_size
        )

        def __verify_sla(
            self,
            time,
            name,
            match_criteria,
            **kwargs
        ):
            """verify_sla  # noqa: E501

            Verify each traffic item matching the criteria meets is below SLA time  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_sla(time, name, match_criteria, async_req=True)
            >>> result = thread.get()

            Args:
                time (int): The time used for comparison
                name (str): The unique name for this verification operation
                match_criteria (MatchCriteria): Match criteria to select requests - response pairs for size tests

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VerifyResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['time'] = \
                time
            kwargs['name'] = \
                name
            kwargs['match_criteria'] = \
                match_criteria
            return self.call_with_http_info(**kwargs)

        self.verify_sla = _Endpoint(
            settings={
                'response_type': (VerifyResult,),
                'auth': [],
                'endpoint_path': '/verify/sla/{time}/{name}',
                'operation_id': 'verify_sla',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'time',
                    'name',
                    'match_criteria',
                ],
                'required': [
                    'time',
                    'name',
                    'match_criteria',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'time',
                    'name',
                ]
            },
            root_map={
                'validations': {
                    ('time',): {

                        'inclusive_minimum': 0,
                    },
                    ('name',): {

                        'regex': {
                            'pattern': r'[a-zA-Z-_]{4,25}',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'time':
                        (int,),
                    'name':
                        (str,),
                    'match_criteria':
                        (MatchCriteria,),
                },
                'attribute_map': {
                    'time': 'time',
                    'name': 'name',
                },
                'location_map': {
                    'time': 'path',
                    'name': 'path',
                    'match_criteria': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_sla
        )
