"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmRule = exports.AlarmState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enumeration indicates state of Alarm used in building Alarm Rule.
 *
 * @stability stable
 */
var AlarmState;
(function (AlarmState) {
    AlarmState["ALARM"] = "ALARM";
    AlarmState["OK"] = "OK";
    AlarmState["INSUFFICIENT_DATA"] = "INSUFFICIENT_DATA";
})(AlarmState = exports.AlarmState || (exports.AlarmState = {}));
/**
 * Enumeration of supported Composite Alarms operators.
 */
var Operator;
(function (Operator) {
    Operator["AND"] = "AND";
    Operator["OR"] = "OR";
    Operator["NOT"] = "NOT";
})(Operator || (Operator = {}));
/**
 * Class with static functions to build AlarmRule for Composite Alarms.
 *
 * @stability stable
 */
class AlarmRule {
    /**
     * function to join all provided AlarmRules with AND operator.
     *
     * @param operands IAlarmRules to be joined with AND operator.
     * @stability stable
     */
    static allOf(...operands) {
        return this.concat(Operator.AND, ...operands);
    }
    /**
     * function to join all provided AlarmRules with OR operator.
     *
     * @param operands IAlarmRules to be joined with OR operator.
     * @stability stable
     */
    static anyOf(...operands) {
        return this.concat(Operator.OR, ...operands);
    }
    /**
     * function to wrap provided AlarmRule in NOT operator.
     *
     * @param operand IAlarmRule to be wrapped in NOT operator.
     * @stability stable
     */
    static not(operand) {
        return new class {
            renderAlarmRule() {
                return `(NOT (${operand.renderAlarmRule()}))`;
            }
        };
    }
    /**
     * function to build TRUE/FALSE intent for Rule Expression.
     *
     * @param value boolean value to be used in rule expression.
     * @stability stable
     */
    static fromBoolean(value) {
        return new class {
            renderAlarmRule() {
                return `${String(value).toUpperCase()}`;
            }
        };
    }
    /**
     * function to build Rule Expression for given IAlarm and AlarmState.
     *
     * @param alarm IAlarm to be used in Rule Expression.
     * @param alarmState AlarmState to be used in Rule Expression.
     * @stability stable
     */
    static fromAlarm(alarm, alarmState) {
        return new class {
            renderAlarmRule() {
                return `${alarmState}("${alarm.alarmArn}")`;
            }
        };
    }
    /**
     * function to build Rule Expression for given Alarm Rule string.
     *
     * @param alarmRule string to be used in Rule Expression.
     * @stability stable
     */
    static fromString(alarmRule) {
        return new class {
            renderAlarmRule() {
                return alarmRule;
            }
        };
    }
    static concat(operator, ...operands) {
        return new class {
            renderAlarmRule() {
                const expression = operands
                    .map(operand => `${operand.renderAlarmRule()}`)
                    .join(` ${operator} `);
                return `(${expression})`;
            }
        };
    }
}
exports.AlarmRule = AlarmRule;
_a = JSII_RTTI_SYMBOL_1;
AlarmRule[_a] = { fqn: "@aws-cdk/aws-cloudwatch.AlarmRule", version: "1.107.0" };
//# sourceMappingURL=data:application/json;base64,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